//
//  ALSacnPlayerView.m
//  GMAlpha
//
//  Created by Jing on 2018/12/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALScanPlayerView.h"
#import "GMPlayerView.h"

@interface ALScanPlayerView ()

@property (nonatomic, strong) GMView *playerPlacehoder;
@property (nonatomic, strong) GMButton *playButton;
@property (nonatomic, strong) GMPlayerView *playerView;
@property (nonatomic, strong) GMButton *confirmButton;

@end

@implementation ALScanPlayerView

- (void)setup {
    [super setup];
    self.animationType = GMPopupAnimationTypeSpringScaleFromCenter;
    self.container.layer.cornerRadius = 5;
    self.container.layer.masksToBounds = YES;
    [self.container mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.center.mas_equalTo(0);
        make.width.mas_equalTo(280);
        make.height.mas_equalTo(356);
    }];
    
    self.playerPlacehoder = [[GMView alloc] init];
    self.playerPlacehoder.backgroundColor = RGBCOLOR_HEX(0xF4F3F8);
    [self.container addSubview:self.playerPlacehoder];
    [self.playerPlacehoder mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.mas_equalTo(0);
        make.height.mas_equalTo(280);
    }];
    
//    self.playerView = [[GMPlayerView alloc] initNoTopicId];
//    [self.container addSubview:self.playerView];
//    [self.playerView mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.top.left.right.mas_equalTo(0);
//        make.height.mas_equalTo(280);
//    }];
    
    self.confirmButton = [GMButton buttonWithTitle:@"确定" backgroundColor:RGBCOLOR_HEX(0x0093FF) titleFontSize:16 titleColor:UIColor.whiteColor];
    self.confirmButton.layer.cornerRadius = 18;
    self.confirmButton.layer.masksToBounds = YES;
    [self.confirmButton addTarget:self action:@selector(hide) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:self.confirmButton];
    [self.confirmButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(190);
        make.height.mas_equalTo(36);
        make.centerX.mas_offset(0);
        make.top.equalTo(self.playerPlacehoder.mas_bottom).offset(20);
    }];
}

- (void)didMoveToSuperview {
    self.playerView = [[GMPlayerView alloc] initNoTopicId];
    [self.playerView play:@"" backView:self.playerPlacehoder];
}

@end
