//
//  AlAtepView.m
//  Animation
//
//  Created by lizhen on 2018/12/7.
//  Copyright © 2018 lizhen. All rights reserved.
//

#import "ALStepView.h"
#import "Masonry/Masonry.h"

@interface ALStepView () <CAAnimationDelegate>
@property (nonatomic, strong) NSMutableArray *leftArray;
@property (nonatomic, strong) UIView *lineView;
@property (nonatomic, strong) UILabel *label;
@property (nonatomic, strong) NSMutableArray *indexArray;
/** 左右转动坐标 */
@property (nonatomic, assign) float animationX;
@end

@implementation ALStepView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        self.backgroundColor = UIColor.clearColor;
        self.leftArray = [NSMutableArray array];
        self.indexArray = [NSMutableArray array];
        [self setupUI];
    }
    return self;
}

- (void)resetUI {
    [self removeFromSuperview];
    [self setupUI];
}

- (void)setupUI {
    NSArray *labelArray = @[@"90°", @"45°", @"0°", @"45°", @"90°"];
    
    self.lineView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, self.frame.size.width, 2)];
    self.lineView.backgroundColor = RGBCOLOR_HEX(0x979797);
    [self addSubview:self.lineView];
    
    for (NSInteger i = 0; i < 5; i++) {
        UIImageView *cicleImg = [[UIImageView alloc] init];
        cicleImg.image = [UIImage imageNamed:@"cicle_gray"];
        cicleImg.tag = 1000 + i;
        [self addSubview:cicleImg];
        
        CGFloat X = (self.frame.size.width - 18)/4 * i;
        // 添加数据
        [self.leftArray addObject:@(X)];
        
        [cicleImg mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(X);
            make.centerY.mas_equalTo(self.lineView.mas_centerY);
            make.size.mas_equalTo(CGSizeMake(18, 18));
        }];
        
        self.label = [[UILabel alloc] init];
        self.label.text = labelArray[i];
        self.label.tag = 2000 + i;
        self.label.font = [UIFont systemFontOfSize:15];
        self.label.textColor = UIColor.grayColor;
        [self addSubview:self.label];
        [self.label mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(cicleImg.mas_bottom).offset(9);
            make.centerX.mas_equalTo(cicleImg.mas_centerX);
        }];
        
        if (i == 2) {
            cicleImg.image = [UIImage imageNamed:@"cicle_blue"];
            [self cicleAnimation:cicleImg delay:1];
            self.label.textColor = RGBCOLOR_HEX(0x0093ff);
        }
    }
}

#pragma mark - 对号缩放
- (void)cicleAnimation:(UIView *)view delay:(NSTimeInterval)delay{
    [UIView animateWithDuration:0.2 delay:delay options:UIViewAnimationOptionLayoutSubviews animations:^{
        view.transform = CGAffineTransformMakeScale(1.2, 1.2);
    } completion:^(BOOL finished) {
        [UIView animateWithDuration:0.2 animations:^{
            view.transform = CGAffineTransformIdentity;
        }];
    }];
}

- (void)setIndex:(float)index {
    _index = index;
    
    float lineWidth = (self.frame.size.width) / 2;
    self.animationX = [self.leftArray[2] floatValue] + 18/2 + index * lineWidth;
    [self drawRectAnimation:1.5];
}

#pragma mark - 页面绘制动画
- (void)drawRectAnimation:(CFTimeInterval)duration {
    UIBezierPath *bezierPath = [UIBezierPath bezierPath];
    
    // 起点
    [bezierPath moveToPoint:CGPointMake([self.leftArray[2] floatValue], 1)];
    // 终点
    [bezierPath addLineToPoint:CGPointMake(self.animationX, 1)];
    
    CAShapeLayer *lineLayer = [CAShapeLayer layer];
    // 关联layer 和贝塞尔路径
    lineLayer.path = bezierPath.CGPath;
    lineLayer.lineWidth = 2;
    lineLayer.strokeColor = RGBCOLOR_HEX(0x0093ff).CGColor;
    lineLayer.fillColor = nil;
    
    // 创建Animation
    CABasicAnimation *animation = [CABasicAnimation animationWithKeyPath:@"strokeEnd"];
    animation.fromValue = @0;
    animation.toValue = @1;
    animation.delegate = self;
    animation.duration = 0;
    
    [lineLayer addAnimation:animation forKey:nil];
    [self.lineView.layer addSublayer:lineLayer];
    
    [self selectedImgAnimation];
}

#pragma mark - 图片选中动画
- (void)selectedImgAnimation {
    NSInteger index = 0;
    if (_index > -0.55 && _index <= -0.45) {
        index = 1;
    } else if (_index == -1.00) {
        index = 0;
    } else if (_index > 0.45 && _index <= 0.55) {
        index = 3;
    } else if (_index == 1.00) {
        index = 4;
    } else {
        index = 2;
    }
    
    // 保证相同的值只被赋值一次
    if (![self.indexArray containsObject:@(index)]) {
        [self.indexArray addObject:@(index)];
    } else {
        return;
    }
    
    for (UIView *view in self.subviews) {
        if (view.tag - 1000 == index) {
            UIImageView *img = (UIImageView *)view;
            img.image = [UIImage imageNamed:@"cicle_blue"];
            [self cicleAnimation:img delay:0];
        } else if (view.tag - 2000 == index) {
            UILabel *label = (UILabel *)view;
            label.textColor = RGBCOLOR_HEX(0x0093ff);
        }
    }
}

@end
