//
//  GMMeViewController.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/5.
//  Copyright © 2018年 Gengmei. All rights reserved.
//

#import "FaceShowViewController.h"
#import <SceneKit/SceneKit.h>
#import "ALScanManager.h"

@interface FaceShowViewController()
@property(nonatomic,strong) SCNView * scnview;
@end

@implementation FaceShowViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    self.scnview = [SCNView new];
    self.scnview.frame = CGRectMake(0, 0, self.view.frame.size.width, self.view.frame.size.height);
    self.scnview.allowsCameraControl = YES;
    self.scnview.backgroundColor = UIColor.blackColor;
    [self.view addSubview:self.scnview];
    [self showhead];
}


- (void) showhead
{
    if(self.showInfo){
        //加载 OBJ
        SCNScene * scene = [SCNScene sceneWithURL:[NSURL fileURLWithPath:[self.showInfo getOBJFile]]
                                            options:nil error:nil];
        // 贴图
        SCNNode * head = scene.rootNode.childNodes[0];
        head.geometry.firstMaterial.lightingModelName = SCNLightingModelBlinn;
        head.geometry.firstMaterial.diffuse.contents  = [self.showInfo getMeshFile];
        /// 显示
        self.scnview.scene = scene;
        NSLog(@" showinfo finish");
        return;
    } else {
        NSString *path = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) lastObject];
        NSString *filePath = [path stringByAppendingPathComponent:@"capture"];
        NSArray *filepaths = [ALScanManager.shareInstance allFilesAtPath:filePath];
        if (filepaths.count > 0) {
            NSArray *endArray = filepaths.lastObject;
            NSString *objPath;
            NSString *uvPath;
            for (NSString *str in endArray) {
                if ([str containsString:@"unrecustom.jpg"]) {
                    uvPath = str;
                } else if ([str containsString:@"unrecustom.obj"]) {
                    objPath = str;
                }
            }
           
            SCNScene * scene = [SCNScene sceneWithURL:[NSURL fileURLWithPath:objPath]
                                              options:nil error:nil];
            // 贴图
            SCNNode * head = scene.rootNode.childNodes[0];
            head.geometry.firstMaterial.lightingModelName = SCNLightingModelBlinn;
            head.geometry.firstMaterial.diffuse.contents  = uvPath;//[fileStr stringByAppendingPathComponent:uvPath, fileStr]];
       
            
            /// 显示
            self.scnview.scene = scene;
        }
       

    }
    NSLog(@"show fail for showinfo is nil");
}

@end
