//
//  AR3DCapture.h
//  UnretekFace3D
//
//  Created by JasWorkSpace on 2018/9/18.
//  Copyright © 2018年 JasWorkSpace. All rights reserved.
//

#ifndef AR3DCapture_h
#define AR3DCapture_h
#include "Unre3DAR3DCaptureInfo.h"

typedef NS_ENUM (NSInteger, AR3DCAPTURESTATETYPE)
{
    AR3DCAPTURE_STATE_IDLE,
    AR3DCAPTURE_STATE_CAPTURE,
    AR3DCAPTURE_STATE_FILESAVE,
    AR3DCAPTURE_STATE_FINISH
};
/////////////////////////////////////////////////////////////////////////
// delegate for capture
@protocol AR3DCaptureDelegate
-(void) captureStateChangeOldState:(AR3DCAPTURESTATETYPE)oldstate andNewState:(AR3DCAPTURESTATETYPE) newstate;
@end
////////////////////////////
typedef void (^AR3DCaptureBlock) (Unre3DAR3DCaptureInfo* captureinfo);
@interface AR3DCapture : NSObject
@property(nonatomic,assign) BOOL debug;
@property(nonatomic,weak)id<AR3DCaptureDelegate> delegate;
- (AR3DCAPTURESTATETYPE) getCurrentCaptureState;
- (AR3DCAPTURESTATETYPE) setCurrentCaptureState:(AR3DCAPTURESTATETYPE)state;
///////////////////////////////////////////////////////
- (BOOL) stopCapture;
- (BOOL) startCaptureWithComplete:(AR3DCaptureBlock)completeMethod;
/////////////////////////////
+ (NSString *) tranformAR3DCAPTURESTATETYPEToNSString:(AR3DCAPTURESTATETYPE)type;
@end
#endif /* AR3DCapture_h */
