//
//  AR3DCapture.m
//  UnretekFace3D
//
//  Created by JasWorkSpace on 2018/9/18.
//  Copyright © 2018年 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "AR3DCapture.h"
#include "AR3DCaptureImpl.h"

@interface AR3DCapture()
@property(nonatomic,assign) AR3DCAPTURESTATETYPE ar3DCaptureCaptureState;
@end

@implementation AR3DCapture

/////////////////////////////////////////////////////////////////////
- (instancetype) init
{
    if(self ==[super init]){
        _ar3DCaptureCaptureState = AR3DCAPTURE_STATE_IDLE;
    }
    return self;
}
////////////////////// API  ////////////////////////////
- (AR3DCAPTURESTATETYPE) getCurrentCaptureState
{
    return _ar3DCaptureCaptureState;
}

- (AR3DCAPTURESTATETYPE) setCurrentCaptureState:(AR3DCAPTURESTATETYPE)state
{
    @synchronized(self){
        if (_ar3DCaptureCaptureState != state){
            AR3DCAPTURESTATETYPE oldstate = _ar3DCaptureCaptureState;
            _ar3DCaptureCaptureState = state;
            if(_delegate){
                [_delegate captureStateChangeOldState:oldstate andNewState:_ar3DCaptureCaptureState];
            }
        }
    }
    return _ar3DCaptureCaptureState;
}

/////////////////////////////////////////////////
- (BOOL) stopCapture
{
    NSLog(@"AR3DCapture we don't how to stopCapture. so we only only return NO");
    return NO;
}

- (BOOL) startCaptureWithComplete:(AR3DCaptureBlock)completeMethod;
{
    NSLog(@"AR3DCapture we don't how to startCaptureWithComplete. so we only return NO");
    return NO;
}
/////////////////////////////////////////////
+ (NSString *) tranformAR3DCAPTURESTATETYPEToNSString:(AR3DCAPTURESTATETYPE)type
{
    switch (type) {
        case AR3DCAPTURE_STATE_IDLE: return @"AR3DCAPTURE_STATE_IDLE";
        case AR3DCAPTURE_STATE_FINISH: return @"AR3DCAPTURE_STATE_FINISH";
        case AR3DCAPTURE_STATE_CAPTURE: return @"AR3DCAPTURE_STATE_CAPTURE";
        case AR3DCAPTURE_STATE_FILESAVE: return @"AR3DCAPTURE_STATE_FILESAVE";
    }
    return [NSString stringWithFormat:@"AR3DCAPTURE_STATE_%zi", type];
}
@end
