//
//  AR3DCaptureImpl.m
//  UnretekFace3D
//
//  Created by JasWorkSpace on 2018/9/18.
//  Copyright © 2018年 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "AR3DCaptureImpl.h"

#include "Unre3DAR3DCaptureImpl.h"
#include "Unre3DARCaptureConfig.h"


@interface AR3DCaptureImpl()

@end

@implementation AR3DCaptureImpl

//////////////////////////////////////////////////////////////////////
- (NSString *) createUnre3DAR3DCapturePath
{
    NSString * capturepath = [[Unre3DARCaptureConfig sharedInstance] getCustomCapturePath];
    [Unre3DARCaptureConfig createPath:capturepath];
    NSString *str = ALScanManager.shareInstance.fittingId;
    //TODO 修改
//    if ([str isNonEmpty]) {
//        capturepath = [NSString stringWithFormat:@"%@/%@", capturepath, str];
//    } else {
//        capturepath = [NSString stringWithFormat:@"%@/alphaCapture3d", capturepath];
//    }
    capturepath = [NSString stringWithFormat:@"%@/alphaCapture3d", capturepath];
    [Unre3DARCaptureConfig createPath:capturepath];
    return capturepath;
}

- (BOOL) reCreateAndUpdateAR3DCaptureInfo:(NSString *) basepath
{
    _captureAR3DCaptureInfo = [[Unre3DAR3DCaptureInfo alloc] initWithBasePath:basepath];
    //NSLog(@"reCreateAndUpdateAR3DCaptureInfo:%@", _captureAR3DCaptureInfo);
    return YES;
}

////////////////////  API  ////////////////////
- (BOOL) createAndUpdateAR3DCaptureInfo
{
    NSLog(@"createAndUpdateAR3DCaptureInfo createAndUpdateAR3DCaptureInfo");
    if([self getCurrentCaptureState] == AR3DCAPTURE_STATE_IDLE){
        NSString * ar3dCaptureInfoBasePath = [self createUnre3DAR3DCapturePath];
        [Unre3DARCaptureConfig createPath:ar3dCaptureInfoBasePath];//make sure path exist.
        return [self reCreateAndUpdateAR3DCaptureInfo:ar3dCaptureInfoBasePath];
    }
    @throw [NSException exceptionWithName:@"ARSessionCapture" reason:@"pls make sure in CAPTURE_STATE_IDLE" userInfo:nil];
}

- (BOOL) initAR3DCaptureEnv
{
    _completeMethod = nil;
    return YES;
}

- (BOOL) releaseAR3DCaptureEnv
{
    _completeMethod = nil;
    return [self setCurrentCaptureState:AR3DCAPTURE_STATE_IDLE];
}

@end
