//
//  FileLoad.cpp
//  Face3D
//
//  Created by JasWorkSpace on 2018/8/2.
//  Copyright © 2018年 JasWorkSpace. All rights reserved.
//

#include "FileLoad.hpp"
#import <Foundation/Foundation.h>

using namespace std;
//using namespace cv;

void objsplit(const string& s,vector<int>& sv,const char flag = ' ') {
    sv.clear();
    istringstream iss(s);
    string temp;
    
    while (getline(iss, temp, flag)) {
        sv.push_back(stoi(temp));
    }
    return;
}

OBJData* getOBJDataFromFile(const char*file)
{
    unsigned char * loadFileContent = nullptr;
    long filesize = 0;
    NSString *nsPath = [NSString stringWithUTF8String:file];
    if(file == nil){
        NSLog(@"getOBJDataFromFile 文件找不到");
        return nullptr;
    }
    NSData *data = [NSData dataWithContentsOfFile:nsPath];
    if([data length] > 0){
        filesize = [data length];
        loadFileContent = new unsigned char[filesize + 1];
        memcpy(loadFileContent,[data bytes],filesize);
        loadFileContent[filesize] = '0';
    }
    return getOBJDataFromFileContent(loadFileContent);
}

OBJData* getOBJDataFromFileContent(unsigned char* fileContent){
    //unsigned char* fileContent = nullptr;
    if(fileContent == nullptr)
    {
        return NULL;
    }
    std::vector<OBJ_V> V;
    std::vector<OBJ_VT> VT;
    std::vector<OBJ_VN> VN;
    std::vector<OBJ_F> F;
    //强转字节流
    std::stringstream ssFileContent((char*)fileContent);
    std::string temp;
    char szOneLine[256];
    while (!ssFileContent.eof())
    {
        memset(szOneLine, 0, 256);
        ssFileContent.getline(szOneLine, 256);
        if(strlen(szOneLine) > 0){
            if (szOneLine[0] == 'v') {
                std::stringstream ssOneLine(szOneLine);
                if(szOneLine[1] == 't'){
                    ssOneLine >> temp;
                    OBJ_VT floatData;
                    ssOneLine >> floatData.v[0];
                    ssOneLine >> floatData.v[1];
                    VT.push_back(floatData);
                } else if(szOneLine[1] == 'n'){
                    ssOneLine >> temp;
                    OBJ_VN floatData;
                    ssOneLine >> floatData.v[0];
                    ssOneLine >> floatData.v[1];
                    ssOneLine >> floatData.v[2];
                    VN.push_back(floatData);
                } else {
                    ssOneLine >> temp;
                    OBJ_V floatData;
                    ssOneLine >> floatData.v[0];
                    ssOneLine >> floatData.v[1];
                    ssOneLine >> floatData.v[2];
                    V.push_back(floatData);
                }
            } else if(szOneLine[0] == 'f'){
                //printf("draw command : %s/n",szOneLine);
                std::stringstream ssOneLine(szOneLine);
                ssOneLine >> temp;
                std::string vertexStr;
                OBJ_F face;
                for (int i = 0; i < 3; i++) {
                    ssOneLine >> vertexStr;
                    vector<int> f;
                    objsplit(vertexStr, f, '/');
                    for(int index=0; index<f.size(); index ++){
                        if(index == 0){
                            face.v[i] = f[index];
                        } else if(index == 1){
                            face.v2[i] = f[index];
                        } else if(index == 2){
                            face.v3[i] = f[index];
                        }
                    }
                }
                F.push_back(face);
            }
        }
    }
    OBJData *data = new OBJData[1];
    data[0].V = V;
    data[0].VT = VT;
    data[0].VN = VN;
    data[0].F = F;
    delete fileContent;
    return data;
}

void releaseOBJData(OBJData* objdata)
{
    objdata[0].V.clear();
    std::vector<OBJ_V>(objdata[0].V).swap(objdata[0].V);
    objdata[0].VT.clear();
    std::vector<OBJ_VT>(objdata[0].VT).swap(objdata[0].VT);
    objdata[0].VN.clear();
    std::vector<OBJ_VN>(objdata[0].VN).swap(objdata[0].VN);
    objdata[0].F.clear();
    std::vector<OBJ_F>(objdata[0].F).swap(objdata[0].F);
}


