//
//  UnOBJUtils.m
//  UnretekFace3D
//
//  Created by JasWorkSpace on 2018/11/9.
//  Copyright © 2018 Unre（Shanghai）Information Technology Co., Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>

#include "UnOBJUtils.h"

@implementation UnOBJUtils

+ (struct OBJData*) getOBJDataFromFile:(NSString *) file
{
    return getOBJDataFromFile([file UTF8String]);
}

+ (NSMutableString *) createOBJFileContentFromOBJData:(struct OBJData *) filedata
{
    NSMutableString * objdic = [[NSMutableString alloc] init];
    if(filedata){
        for(int i=0; i< filedata->V.size(); i++){
            OBJ_V data = filedata->V[i];
            [objdic appendString:[NSString stringWithFormat:@"v %f %f %f\n", data.v[0], data.v[1], data.v[2]]];
        }
        for (int i=0; i< filedata->VT.size(); i++) {
            OBJ_VT data = filedata->VT[i];
            [objdic appendString:[NSString stringWithFormat:@"vt %f %f\n",data.v[0], data.v[1]]];
        }
        for (int i=0; i< filedata->VN.size(); i++) {
            OBJ_VN data = filedata->VN[i];
            [objdic appendString:[NSString stringWithFormat:@"vn %f %f %f\n",data.v[0], data.v[1], data.v[2]]];
        }
        for(int i=0; i< filedata->F.size(); i++){
            OBJ_F data = filedata->F[i];
            [objdic appendString:[NSString stringWithFormat:@"f %d/%d %d/%d %d/%d\n",
                                  data.v[0], data.v[0],
                                  data.v[1], data.v[1],
                                  data.v[2], data.v[2]]];
        }
    }
    return objdic;
}

+ (BOOL) saveOBJData:(struct OBJData*)source toFile:(NSString*)file
{
    return [[UnOBJUtils createOBJFileContentFromOBJData:source] writeToFile:file atomically:YES encoding:NSUTF8StringEncoding error:nil];
}

@end
