//
//  Unre3DAR3DCaptureImpl.h
//  UnretekFace3D
//
//  Created by JasWorkSpace on 2018/11/15.
//  Copyright © 2018 Unre（Shanghai）Information Technology Co., Ltd. All rights reserved.
//

#ifndef Unre3DAR3DCaptureImpl_h
#define Unre3DAR3DCaptureImpl_h
#import <UIKit/UIKit.h>
#include "AR3DCaptureImpl.h"
#include "Unre3DAR3DCaptureInfo.h"

#ifndef Unre3D_Mobile
#define Unre3D_Mobile 1
#endif
//////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, Unre3DAR3DFaceType)
{
    Unre3DAR3DFacePositionReadyToScan,
    Unre3DAR3DFacePositionFaceNotFound,
    Unre3DAR3DFacePositionFaceNotFrontal,
    Unre3DAR3DFacePositionFaceTooClose,
    Unre3DAR3DFacePositionFaceTooFar,
    Unre3DAR3DFacePositionFaceNotCentered,
    Unre3DAR3DFacePositionNotAvailable
};

typedef NS_ENUM(NSInteger, Unre3DAR3DScanHint)
{
    Unre3DAR3DScanHintNone,
    Unre3DAR3DScanHintHoldStill,
    Unre3DAR3DScanHintCountdownThree,
    Unre3DAR3DScanHintCountdownTwo,
    Unre3DAR3DScanHintCountdownOne,
    Unre3DAR3DScanHintTurnHeadLeft,
    Unre3DAR3DScanHintKeepHeadTurning,
    Unre3DAR3DScanHintTurnHeadRight,
    Unre3DAR3DScanHintTurnHeadToTheMiddle,
    Unre3DAR3DScanHintCaptureCompleted,
    Unre3DAR3DScanHintCaptureAboutToStop
};
typedef NS_ENUM(NSInteger, Unre3DAR3DFAILHint)
{
    Unre3DAR3DFAILHintCapture,// 拍摄错误
    Unre3DAR3DFAILHintStartProcess,// 启动生成 OBJ 错误
    Unre3DAR3DFAILHintStartProcessNULL,//// 启动生成 OBJ 错误
    Unre3DAR3DFAILHintProcess //OBJ 生成错误
};

@protocol Unre3DAR3DCaptureImplDelegate
@required
- (void) notifyUnre3DAR3DFaceType:(Unre3DAR3DFaceType) type;
@required
- (void) notifyHeadPosition:(float)currentHeadPosition;
@required
- (void) notifyScanHint:(Unre3DAR3DScanHint) hint;
@required
- (void) notifyProcessorProcessing:(float)progress;
@required
- (void) notifyCaptureFAIL:(Unre3DAR3DFAILHint) hint;
@end
//////////////////////////////////
@interface Unre3DAR3DCaptureImpl : AR3DCaptureImpl
@property(nonatomic,weak)id<Unre3DAR3DCaptureImplDelegate> unre3DAR3DCaptureImplDelegate;
- (void) setPreviewUIView:(UIView *)previewUIView;
//////////////////////////////
- (BOOL) startPreView;
- (BOOL) stopPreView;
- (BOOL) createOBJ;
/////////////////////////////////////////
- (BOOL) notifyCapturefinishH:(BOOL) success;// 内部使用
//////////////////////
+ (NSString *) tranformUnre3DAR3DFaceTypeToNSString:(Unre3DAR3DFaceType) type;
+ (NSString *) tranformUnre3DAR3DScanHintToNSString:(Unre3DAR3DScanHint) hint;
@end

#endif /* Unre3DAR3DCaptureImpl_h */
