//
//  Unre3DAR3DCaptureImpl.m
//  UnretekFace3D
//
//  Created by JasWorkSpace on 2018/11/15.
//  Copyright © 2018 Unre（Shanghai）Information Technology Co., Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "Unre3DAR3DCaptureImpl.h"

#if Unre3D_Mobile
#include "Unre3DImpl.h"
#endif

@interface Unre3DAR3DCaptureImpl()
@property(nonatomic,strong) UIView * previewUIView;
#if Unre3D_Mobile
@property(nonatomic,strong) Unre3DImpl *unre3DImpl;
#endif
@end

@implementation Unre3DAR3DCaptureImpl


- (instancetype) init
{
    if(self == [super init]){
        [self commitUnre3DAR3DCaptureImplInit];
    }
    return self;
}

- (void) commitUnre3DAR3DCaptureImplInit
{
    //[self createAndUpdateAR3DCaptureInfo];
#if Unre3D_Mobile
    _unre3DImpl = [[Unre3DImpl alloc] initWithUnre3DAR3DCaptureImpl:self];
#endif
}
///////////////////////////////////////////////////////////
-(void)setUnre3DAR3DCaptureImplDelegate:(id<Unre3DAR3DCaptureImplDelegate>)unre3DAR3DCaptureImplDelegate
{
    _unre3DAR3DCaptureImplDelegate = unre3DAR3DCaptureImplDelegate;
#if Unre3D_Mobile
    _unre3DImpl.unre3DAR3DCaptureImplDelegate = _unre3DAR3DCaptureImplDelegate;
#endif
}
///////////////////////////////////////////////////////////
- (void) setPreviewUIView:(UIView *)previewUIView
{
    _previewUIView = previewUIView;
}
///////////////////////////// API //////////////////////////////////////////
- (BOOL) startPreView
{
    NSLog(@"startPreView startPreView %@", _unre3DImpl);
#if Unre3D_Mobile
    if(_unre3DImpl){
        NSLog(@"capimpl startPreView startPreView");
        return [_unre3DImpl startPreView:_previewUIView];
    }
#endif
    return NO;
}

- (BOOL) stopPreView
{
#if Unre3D_Mobile
    if(_unre3DImpl){
        return [_unre3DImpl stopPreView];
    }
#endif
    return NO;
}

- (BOOL) createOBJ
{
#if Unre3D_Mobile
    NSLog(@"%@", [AR3DCapture tranformAR3DCAPTURESTATETYPEToNSString:[self getCurrentCaptureState]]);
    if([self getCurrentCaptureState] == AR3DCAPTURE_STATE_FILESAVE){
        return [_unre3DImpl createOBJ];
    }
#endif
    return NO;
}

- (BOOL) stopCapture
{
    return [self releaseAR3DCaptureEnv];
}

- (BOOL) startCaptureWithComplete:(AR3DCaptureBlock)completeMethod
{
#if Unre3D_Mobile
    if([self getCurrentCaptureState] != AR3DCAPTURE_STATE_IDLE){//we need all prepera
        return NO;
    }
    if(!_unre3DImpl){
        NSLog(@"we don't know how to capture for unre3DImpl is nil");
        return NO;
    }
    if(![self initAR3DCaptureEnv]){
        return NO;
    }
    //Unre3D no need create new dir.
    if(![self createAndUpdateAR3DCaptureInfo]){
        return NO;
    }
    BOOL startResult = [self startCheckAndStartCaptureARSession];//now we start to loop capture.
    if(startResult){
        self.completeMethod = completeMethod;//load it.
    }
    return startResult;
#else
    return NO;
#endif
}
////////////////////////////
- (BOOL) notifyCapturefinishH:(BOOL) success
{
    if([self getCurrentCaptureState] == AR3DCAPTURE_STATE_CAPTURE
       || [self getCurrentCaptureState] == AR3DCAPTURE_STATE_FILESAVE){
        if(success){
            if(self.completeMethod){
                self.completeMethod(self.captureAR3DCaptureInfo);
            }
        }
        [self setCurrentCaptureState:AR3DCAPTURE_STATE_FINISH];//标记完成
        [self releaseAR3DCaptureEnv];//释放资源，并标记IDLE
        return YES;
    }
    return NO;
}
///////////////////////////////////////////////////////////////////////
- (BOOL) startCheckAndStartCaptureARSession
{
#if Unre3D_Mobile
    if([self getCurrentCaptureState] == AR3DCAPTURE_STATE_IDLE
       && ([self setCurrentCaptureState:AR3DCAPTURE_STATE_CAPTURE] == AR3DCAPTURE_STATE_CAPTURE)){
        if(_unre3DImpl){
            __weak Unre3DAR3DCaptureInfo* info = (Unre3DAR3DCaptureInfo*) self.captureAR3DCaptureInfo;
            NSLog(@"start capture info:%@, capture:%@", info, self.captureAR3DCaptureInfo);
            return [_unre3DImpl startCapture:info];
        }
    }
#endif
    return NO;
}
////////////////////////////////////////////////////////////////////////////////////////

+ (NSString *) tranformUnre3DAR3DFaceTypeToNSString:(Unre3DAR3DFaceType) type
{
    switch (type) {
        case Unre3DAR3DFacePositionFaceTooFar: return @"Unre3DAR3DFacePositionFaceTooFar";
        case Unre3DAR3DFacePositionReadyToScan: return @"Unre3DAR3DFacePositionReadyToScan";
        case Unre3DAR3DFacePositionFaceNotFound: return @"Unre3DAR3DFacePositionReadyToScan";
        case Unre3DAR3DFacePositionFaceTooClose: return @"Unre3DAR3DFacePositionFaceTooClose";
        case Unre3DAR3DFacePositionNotAvailable: return @"Unre3DAR3DFacePositionNotAvailable";
        case Unre3DAR3DFacePositionFaceNotFrontal: return @"Unre3DAR3DFacePositionFaceNotFrontal";
        case Unre3DAR3DFacePositionFaceNotCentered: return @"Unre3DAR3DFacePositionFaceNotCentered";
    }
    return [NSString stringWithFormat:@"Unre3DAR3DFacePosition_%zi", type];
}

+ (NSString *) tranformUnre3DAR3DScanHintToNSString:(Unre3DAR3DScanHint) hint
{
    switch(hint){
        case Unre3DAR3DScanHintTurnHeadToTheMiddle: return @"Unre3DAR3DScanHintTurnHeadToTheMiddle";
        case Unre3DAR3DScanHintCaptureAboutToStop: return @"Unre3DAR3DScanHintCaptureAboutToStop";
        case Unre3DAR3DScanHintCaptureCompleted: return @"Unre3DAR3DScanHintCaptureCompleted";
        case Unre3DAR3DScanHintKeepHeadTurning: return @"Unre3DAR3DScanHintKeepHeadTurning";
        case Unre3DAR3DScanHintTurnHeadRight: return @"Unre3DAR3DScanHintTurnHeadRight";
        case Unre3DAR3DScanHintTurnHeadLeft: return @"Unre3DAR3DScanHintTurnHeadLeft";
        case Unre3DAR3DScanHintNone: return @"Unre3DAR3DScanHintNone";
        case Unre3DAR3DScanHintHoldStill: return @"Unre3DAR3DScanHintHoldStill";
        case Unre3DAR3DScanHintCountdownOne: return @"Unre3DAR3DScanHintCountdownOne";
        case Unre3DAR3DScanHintCountdownTwo: return @"Unre3DAR3DScanHintCountdownTwo";
        case Unre3DAR3DScanHintCountdownThree: return @"Unre3DAR3DScanHintCountdownThree";
    }
    return [NSString stringWithFormat:@"Unre3DAR3DScanHint_%zi", hint];
}


@end
