//
//  Unre3DAR3DCaptureInfo.m
//  UnretekFace3D
//
//  Created by JasWorkSpace on 2018/11/15.
//  Copyright © 2018 Unre（Shanghai）Information Technology Co., Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "Unre3DAR3DCaptureInfo.h"

///////////////////////////
@interface Unre3DAR3DCaptureInfo()

@end
@implementation Unre3DAR3DCaptureInfo

-(instancetype)initWithBasePath:(NSString *)basepath
{
    if(self == [super init]){
        _basePath = basepath;
        [self commitBellus3DAR3DCaptureInfoInit];
    }
    return self;
}

- (void) commitBellus3DAR3DCaptureInfoInit
{
    _CustomFileName = @"unrecustom";
}

- (NSString *) getFileName//获取当前的文件名
{
    return _CustomFileName;
}

- (NSString *) getOBJFile//获取当前 obj 文件路径。
{
    return [NSString stringWithFormat:@"%@/%@.obj", _basePath, _CustomFileName];
}

- (NSString *) getMeshFile//获取当前贴图文件路径
{
    return [NSString stringWithFormat:@"%@/%@.jpg", _basePath, _CustomFileName];
}

- (NSString *) getMtlFile//获取当前贴图文件路径
{
    return [NSString stringWithFormat:@"%@/%@.mtl", _basePath, _CustomFileName];
}


- (NSString *)description
{
    return [NSString stringWithFormat:@"{basePath:%@, CustomFileName:%@, objfile:%@, meshfile:%@}",
            _basePath,
            _CustomFileName,
            [self getOBJFile],
            [self getMeshFile]];
}


- (instancetype)initWithCoder:(NSCoder *)aDecoder {
    if (self = [super init]) {
        self.basePath= [aDecoder decodeObjectForKey:@"basePath"];
        self.CustomFileName= [aDecoder decodeObjectForKey:@"CustomFileName"];
    }
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder {
    [aCoder encodeObject:self.basePath forKey:@"basePath"];
    [aCoder encodeObject:self.CustomFileName forKey:@"CustomFileName"];
}

@end
