//
//  Unre3DARCaptureConfig.m
//  scandemo
//
//  Created by JasWorkSpace on 2018/11/22.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#import "Unre3DARCaptureConfig.h"

static Unre3DARCaptureConfig *__mInstance;

@interface Unre3DARCaptureConfig()
@property(nonatomic,strong) NSString * capturePath;
@property(nonatomic,strong) NSString * captureTempPath;
@end

@implementation Unre3DARCaptureConfig


+ (Unre3DARCaptureConfig *) sharedInstance
{
    static dispatch_once_t oneToken;
    dispatch_once(&oneToken, ^{
        __mInstance = [[Unre3DARCaptureConfig alloc]init];//maybe double set __mInstance
    });
    return __mInstance;
}

+ (instancetype) alloc {
    NSCAssert(!__mInstance, @"Unre3DARCaptureConfig 只能初始化一次");
    return [super alloc];
}

- (instancetype)init
{
    NSCAssert(!__mInstance, @"Unre3DARCaptureConfig 只能初始化一次");
    self = [super init];
    if (self) {
        __mInstance = self;
        NSArray *array =  NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
        NSString * documentpath = [array objectAtIndex:0];
        _capturePath = [NSString stringWithFormat:@"%@/capture", documentpath];
        _captureTempPath = @"UnreScan";//scanframework 会在 document 下面创建  UnreScan 目录。
    }
    return self;
}

- (NSString *)description
{
    return [NSString stringWithFormat:@"{capturePath:%@,captureTempPath:%@}",
            _capturePath,
            _captureTempPath];
}

+ (BOOL) createPath:(NSString *) path
{
    BOOL isDir = NO;
    NSFileManager *fileManager = [NSFileManager defaultManager];
    BOOL existed = [fileManager fileExistsAtPath:path isDirectory:&isDir];
    if ( !(isDir == YES && existed == YES) )
    {
        return [fileManager createDirectoryAtPath:path withIntermediateDirectories:YES attributes:nil error:nil];
    }
    return YES;
}

- (NSString *) getCustomCapturePath
{
    return [NSString stringWithFormat:@"%@", _capturePath];
}

- (NSString *) getCustomCaptureTempPath
{
    return [NSString stringWithFormat:@"%@", _captureTempPath];
}

@end
