//
//  Unre3DImpl.h
//  UnretekFace3D
//
//  Created by JasWorkSpace on 2018/11/1.
//  Copyright © 2018 Unre（Shanghai）Information Technology Co., Ltd. All rights reserved.
//

#ifndef Unre3DImpl_h
#define Unre3DImpl_h

#include "Unre3DAR3DCaptureImpl.h"
#include "Unre3DAR3DCaptureInfo.h"

#import "UnreScanLib/U3DCamera.h"
#import "UnreScanLib/U3DHeadMesh.h"
#import "UnreScanLib/U3DHeadProcessor.h"
//#import "UnreScanLib/U3DHeadProcessorSettings.h"
#import "UnreScanLib/U3DHeadScanner.h"
#import "UnreScanLib/U3DHeadScannerProgressInfo.h"
#import "UnreScanLib/U3DSessionData.h"


@interface Unre3DCameraII : Unre3DCamera
- (BOOL) setPreviewUIView:(UIView *)previewUIView;
@end
/////////////////////////////////////
@protocol Unre3DScannerDelegate
-(void) notifyCompleteScanningSuccessfully:(BOOL)completedSuccessfully;
@end
@interface UnreScannerII : NSObject
//- (instancetype)initWithBasePath:(NSString*)basepath;
@property(nonatomic,weak)id<Unre3DHeadScannerObserver> head3DScannerDelegate;
@property(nonatomic,weak)id<Unre3DAR3DCaptureImplDelegate> unre3DAR3DCaptureImplDelegate;
@property(nonatomic,weak)id<Unre3DScannerDelegate> unre3DScannerDelegateH;// Unre3DImpl 专用
///////////////////////
- (BOOL) setPreviewUIView:(UIView *)previewUIView;
//////////////////////
- (BOOL) startScanner:(Unre3DAR3DCaptureInfo*) unre3DAR3DCaptureInfo;;
- (BOOL) startTracking;
- (BOOL) cancel;
@end
////////////////////////////////////////////
@protocol Unre3DProcessorDelegate
- (void) notifyCompleteProcessingWithMesh:(BOOL) completedSuccessfully;
@end
@interface Unre3DProcessor : NSObject
@property(nonatomic,weak)id<Unre3DAR3DCaptureImplDelegate> unre3DAR3DCaptureImplDelegate;
@property(nonatomic,weak)id<Unre3DProcessorDelegate> unre3DProcessorDelegateH;// Bellus3DImpl 专用
////////////////////////////////////////////
@end
///////////////////////////////////////////////
@interface Unre3DImpl : NSObject
//- (instancetype) initWithBasePath:(NSString *) basepath;
@property(nonatomic,weak)id<Unre3DAR3DCaptureImplDelegate> unre3DAR3DCaptureImplDelegate;
/////////////////
- (instancetype) initWithUnre3DAR3DCaptureImpl:(Unre3DAR3DCaptureImpl*) impl;
- (BOOL) startPreView:(UIView *)previewUIView;
- (BOOL) stopPreView;
- (BOOL) createOBJ;
- (BOOL) startCapture:(Unre3DAR3DCaptureInfo*) unre3DAR3DCaptureInfo;
@end
#endif

