//
//  AudioPlayUtils.m
//  UnretekFace3D
//
//  Created by JasWorkSpace on 2018/10/9.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>

#include "AudioPlayUtils.h"
#import <AudioToolbox/AudioToolbox.h>
#import <AVFoundation/AVFoundation.h>

@implementation AudioPlayUtils

/////////////////////////////////////////////////////////////////////////////////////
void soundCompleteCallback(SystemSoundID soundID,void * clientData){
    NSLog(@"播放完成...");
}
/** * 播放音效文件 * * @param name 音频文件名称 */
+ (BOOL) playSoundEffect:(NSString *)name
{
    NSString *audioFile=[[NSBundle mainBundle] pathForResource:name ofType:nil];
    NSURL *fileUrl=[NSURL fileURLWithPath:audioFile];
    //1.获得系统声音ID
    SystemSoundID soundID=0;
    /**     * inFileUrl: 音频文件url     * outSystemSoundID:声 id(此函数会将音效文件加入到系统音频服务中并返回一个长整形ID) */
    AudioServicesCreateSystemSoundID((__bridge CFURLRef)(fileUrl), &soundID);
    //如果需要在播放完之后执行某些操作,可以调用如下方法注册一个播放完成回调函数
    //AudioServicesAddSystemSoundCompletion(soundID, NULL, NULL, soundCompleteCallback, NULL);
    //2.播放音频
    AudioServicesPlaySystemSound(soundID);//播放音效
    // AudioServicesPlayAlertSound(soundID);//播放音效并震动
    return YES;
}
//////////////////////////////////////////////////////////////////////////////////////
+ (BOOL) audioPlayer:(NSString *)name
{
    NSString *urlStr=[[NSBundle mainBundle]pathForResource:name ofType:nil];
    NSURL *url=[NSURL fileURLWithPath:urlStr];
    NSError *error=nil;
    //初始化播放器，注意这里的Url参数只能时文件路径，不支持HTTP Url
    AVAudioPlayer* audioPlayer=[[AVAudioPlayer alloc] initWithContentsOfURL:url error:&error];
    if(error){
        NSLog(@"初始化播放器过程发生错误,错误信息:%@",error.localizedDescription);
        return NO;
    }
    //设置播放器属性
    audioPlayer.numberOfLoops=0;//设置为0不循环
    //audioPlayer.delegate=self;
    [audioPlayer prepareToPlay];//加载音频文件到缓存
    [audioPlayer play];
    return YES;
}


@end
