//
//  HomeHelper.m
//  UnretekFace3D
//
//  Created by JasWorkSpace on 2018/10/15.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "HomeHelper.h"

@interface HomeHelper()<HomeHelperDegelate>
@property(nonatomic,assign)BOOL startListener;
@end

@implementation HomeHelper

- (BOOL) enable:(BOOL)enable
{
    self.startListener = enable;
    return self.startListener;
}

//////////////////////////////////////////////////////
-(void)setStartListener:(BOOL)startListener
{
    @synchronized (self) {
        if(_startListener != startListener){
            _startListener = startListener;
            if(_startListener){
                [self start];
            } else {
                [self stop];
            }
        }
    }
}
///////////////////////////////////////////////////////
- (void) start
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationWillResignActive:)
                                                 name:UIApplicationWillResignActiveNotification object:nil]; //监听是否触发home键挂起程序.
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationDidBecomeActive:)
                                                 name:UIApplicationDidBecomeActiveNotification object:nil]; //监听是否重新进入程序程序.
}

- (void) stop
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

-(void)dealloc
{
    self.startListener = NO;
}
///////////////////////// Degelate ////////////////////

- (void) applicationWillResignActive:(NSNotification *)notification
{
    //NSLog(@"applicationWillResignActive");
    if(self.delegate && [self.delegate respondsToSelector:NSSelectorFromString(@"applicationWillResignActive:")]){
        [_delegate applicationWillResignActive:notification];
    }
}

- (void) applicationDidBecomeActive:(NSNotification *)notification
{
    //NSLog(@"applicationDidBecomeActive");
    if(self.delegate && [self.delegate respondsToSelector:NSSelectorFromString(@"applicationDidBecomeActive:")]){
        [_delegate applicationDidBecomeActive:notification];
    }
}

@end
