//
//  HomeUIButton.m
//  UnretekFace3D
//
//  Created by JasWorkSpace on 2018/11/11.
//  Copyright © 2018 Unre（Shanghai）Information Technology Co., Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "HomeUIButton.h"

@implementation HomeUIButton

- (instancetype)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame]){
        [self commitHomeUIButtonInit];
    }
    return self;
}

- (void) commitHomeUIButtonInit
{
    self.divideScale = 0.6;
    self.titleLabel.textAlignment = NSTextAlignmentCenter;
    self.imageView.contentMode = UIViewContentModeScaleAspectFit;
    self.titleLabel.font = [UIFont fontWithName:@"Helvetica" size:14.0f];
}

- (void)setDivideScale:(float)divideScale
{
    if(_divideScale != divideScale){
        _divideScale = divideScale;
        [self setNeedsLayout];
        [self layoutIfNeeded];
    }
}

- (CGRect)titleRectForContentRect:(CGRect)contentRect
{
    CGFloat titleY = contentRect.size.height * self.divideScale;
    CGFloat titleW = contentRect.size.width;
    CGFloat titleH = contentRect.size.height - titleY;
    return CGRectMake(0, titleY , titleW, titleH);
}

- (CGRect)imageRectForContentRect:(CGRect)contentRect
{
    CGFloat imageW = CGRectGetWidth(contentRect);
    CGFloat imageH = contentRect.size.height * self.divideScale;
    return CGRectMake(0, 0, imageW, imageH);
}


@end
