//
//  ALCountryNumPickView.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/27.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALCountryNumPickView.h"
#import "ALBindPhoneController.h"

@interface PickCellView : GMView

@property (nonatomic, strong) GMLabel *leftLabel;

@property (nonatomic, strong) GMLabel *rightLabel;

@property (nonatomic, strong) ALConfigPhoneAreaObject *model;

@end

@implementation PickCellView

- (void)setup
{
    [super setup];
    
    [self addSubview:self.leftLabel];
    [self addSubview:self.rightLabel];
    
    [self.leftLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.mas_left).offset(30);
        make.centerY.equalTo(self.mas_centerY);
    }];
    [self.rightLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self.mas_right).offset(-30);
        make.centerY.equalTo(self.mas_centerY);
    }];
}

- (void)setModel:(ALConfigPhoneAreaObject *)model
{
    _model = model;
    
    self.leftLabel.text = model.area;
    
    self.rightLabel.text = model.code;
}

- (GMLabel *)leftLabel
{
    if (!_leftLabel) {
        _leftLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:22];
    }
    return _leftLabel;
}

- (GMLabel *)rightLabel
{
    if (!_rightLabel) {
        _rightLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:22];
    }
    return _rightLabel;
}

@end

@interface ALCountryNumPickView ()<UIPickerViewDelegate,UIPickerViewDataSource>

@property (nonatomic ,strong)UIView *toolsView;
@property (nonatomic ,strong)UIPickerView *picerView;

@property (nonatomic ,strong)NSArray <ALConfigPhoneAreaObject *>*componentArray;
@property (nonatomic, assign) BOOL isChange;
//@property (nonatomic ,strong)NSArray *titleArray;

@end

@implementation ALCountryNumPickView

-(void)setup
{
    [super setup];
}

- (instancetype)initWithComponentDataArray:(NSArray<ALConfigPhoneAreaObject *> *)ComponentDataArray
{
    self = [super init];
    if (self)
    {
        self.componentArray = ComponentDataArray;
//        self.titleArray = titleDataArray;
        self.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT);
        
        self.backgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:0];
        [UIView animateWithDuration:0.3 animations:^{
            self.backgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:0.3];
        }];
        
        _toolsView = [[UIView alloc] initWithFrame:CGRectMake(0, MAINSCREEN_HEIGHT - 230, MAINSCREEN_WIDTH, 40)];
        _toolsView.backgroundColor = UIColor.background;
        [self addSubview:_toolsView];
        
        // 右边确定按钮
        GMButton *rightSureBtn = [GMButton buttonWithTitle:@"确定" backgroundColor:nil titleFontSize:17 titleColor:RGBCOLOR_HEX(0x0093ff)];
        rightSureBtn.frame = CGRectMake(MAINSCREEN_WIDTH - 66, 0, 36, 40);
        [rightSureBtn addTarget:self action:@selector(rightButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        [_toolsView addSubview:rightSureBtn];
        
        // 左边取消按钮
        GMButton *leftCancleButton = [GMButton buttonWithTitle:@"取消" backgroundColor:nil titleFontSize:17 titleColor:UIColor.auxiliaryTextLight];
        leftCancleButton.frame = CGRectMake(30, 0, 36, 40);
        [leftCancleButton addTarget:self action:@selector(leftButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        [_toolsView addSubview:leftCancleButton];
        
        _picerView = [[UIPickerView alloc] initWithFrame:CGRectMake(0, MAINSCREEN_HEIGHT - 190, MAINSCREEN_WIDTH, 190)];
        _picerView.dataSource = self;
        _picerView.delegate = self;
        [_picerView selectRow:0 inComponent:0 animated:YES];
        _picerView.backgroundColor = [UIColor whiteColor];
        [self addSubview:_picerView];
    }
    return self;
}


#pragma mark -
#pragma mark -  左边按钮 方法  取消
- (void)leftButtonClick:(UIButton *)button
{
    self.isChange = NO;
    [self dissMissPickView];
}
#pragma mark -  右边按钮  方法
- (void)rightButtonClick:(UIButton *)button
{
    self.isChange = YES;
    
    if (self.codeStr == nil) {
        [self setDataValue];
    }
    
    [self dissMissPickView];
}

- (void)setDataValue
{
    ALConfigPhoneAreaObject *model = self.componentArray.firstObject;
    self.countryStr = model.area;
    self.codeStr = model.code;
}
#pragma mark -
#pragma mark -  数据源方法
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 1;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component
{
    return self.componentArray.count;
}

- (UIView *)pickerView:(UIPickerView *)pickerView viewForRow:(NSInteger)row forComponent:(NSInteger)component reusingView:(nullable UIView *)view
{
    PickCellView *pickCellView = [[PickCellView alloc]init];
    
    pickCellView.model = self.componentArray[row];
    
    return pickCellView;
}

#pragma mark -
#pragma mark -  代理方法
- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
    ALConfigPhoneAreaObject *model = self.componentArray[row];
    self.countryStr = model.area;
    self.codeStr = model.code;
}
#pragma mark -
#pragma mark - 屏幕点击事件
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [self dissMissPickView];
}


#pragma mark -
#pragma mark - 消失的方法
- (void)dissMissPickView
{
    if (self.getPickerValue)
    {
        self.getPickerValue(self.isChange,self.codeStr);
    }
    __weak typeof (self)weakSelf = self;
    __weak typeof(UIView *)blockView = _toolsView;
    __weak typeof(UIPickerView *)blockPickerViwe = _picerView;
    [UIView animateWithDuration:0.3 animations:^{
        blockView.frame = CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, 44);
        blockPickerViwe.frame = CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, 200);
    }completion:^(BOOL finished) {
        [weakSelf removeFromSuperview];
    }];
}


@end
