//
//  GMAreaCodeCell.m
//  Gengmei
//
//  Created by 汪俊 on 2016/11/22.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMAreaCodeCell.h"

@implementation GMAreaCodeCell

- (void)setup {
    [super setup];
    self.backgroundColor = [UIColor clearColor];
    _nationLabel = [GMLabel labelWithTextColor:UIColor.bodyText fontSize:13];
    [self.contentView addSubview:_nationLabel];
    [_nationLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.centerY.mas_equalTo(0);
    }];
    
    _codeLabel = [GMLabel labelWithTextColor:UIColor.bodyText fontSize:13];
    _codeLabel.textAlignment = NSTextAlignmentRight;
    [self.contentView addSubview:_codeLabel];
    [_codeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-15);
        make.centerY.mas_equalTo(0);
    }];
}

- (void)setHighlighted:(BOOL)highlighted animated:(BOOL)animated {
    [super setHighlighted:highlighted animated:animated];
    _nationLabel.textColor =  highlighted ? UIColor.mainVisual : UIColor.bodyText;
    _codeLabel.textColor = highlighted ? UIColor.mainVisual : UIColor.bodyText;
}
@end
