//
//  ALAgeSelectPickView.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/12/9.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALAgeSelectPickView.h"
#import "ALConfigObject.h"

@interface PickCellAgeView : GMView

@property (nonatomic, strong) GMLabel *centerLabel;

@property (nonatomic, copy) NSString *ageStr;

@end

@implementation PickCellAgeView

- (void)setup
{
    [super setup];
    
    [self addSubview:self.centerLabel];
    
    [self.centerLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.mas_centerX);
        make.centerY.equalTo(self.mas_centerY);
    }];

}

- (void)setAgeStr:(NSString *)ageStr
{
    self.centerLabel.text = ageStr;
}

- (GMLabel *)centerLabel
{
    if (!_centerLabel) {
        _centerLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:22];
        _centerLabel.textAlignment = NSTextAlignmentCenter;
    }
    return _centerLabel;
}


@end

@interface ALAgeSelectPickView ()<UIPickerViewDelegate,UIPickerViewDataSource>

@property (nonatomic ,strong)UIView *toolsView;

@property (nonatomic ,strong)UIPickerView *picerView;

@property (nonatomic, assign) BOOL isChange;

@property (nonatomic ,strong)ALConfigObject *model;

@end

@implementation ALAgeSelectPickView

-(void)setup
{
    [super setup];
    [self setUI];
}
- (void)setUI
{
    
    NSUserDefaults *user = [NSUserDefaults standardUserDefaults];
    NSDictionary *data = [user objectForKey:@"phoneAreaKey"];
    if (data) {
        self.model = [[ALConfigObject alloc] initWithDictionary:data error:nil];
    }
    self.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT);
    
    self.backgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:0];
    [UIView animateWithDuration:0.3 animations:^{
        self.backgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:0.3];
    }];
    
    _toolsView = [[UIView alloc] initWithFrame:CGRectMake(0, MAINSCREEN_HEIGHT - 230, MAINSCREEN_WIDTH, 40)];
    _toolsView.backgroundColor = UIColor.background;
    [self addSubview:_toolsView];
    
    // 右边确定按钮
    GMButton *rightSureBtn = [GMButton buttonWithTitle:@"确定" backgroundColor:nil titleFontSize:17 titleColor:RGBCOLOR_HEX(0x0093ff)];
    rightSureBtn.frame = CGRectMake(MAINSCREEN_WIDTH - 66, 0, 36, 40);
    [rightSureBtn addTarget:self action:@selector(rightButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    [_toolsView addSubview:rightSureBtn];
    
    // 左边取消按钮
    GMButton *leftCancleButton = [GMButton buttonWithTitle:@"取消" backgroundColor:nil titleFontSize:17 titleColor:UIColor.auxiliaryTextLight];
    leftCancleButton.frame = CGRectMake(30, 0, 36, 40);
    [leftCancleButton addTarget:self action:@selector(leftButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    [_toolsView addSubview:leftCancleButton];
    
    _picerView = [[UIPickerView alloc] initWithFrame:CGRectMake(0, MAINSCREEN_HEIGHT - 190, MAINSCREEN_WIDTH, 190)];
    _picerView.dataSource = self;
    _picerView.delegate = self;
    [_picerView selectRow:0 inComponent:0 animated:YES];
    _picerView.backgroundColor = [UIColor whiteColor];
    [self addSubview:_picerView];
}

#pragma mark -  左边按钮 方法  取消
- (void)leftButtonClick:(UIButton *)button
{
    self.isChange = NO;
    [self dissMissPickView];
}
#pragma mark -  右边按钮  方法
- (void)rightButtonClick:(UIButton *)button
{
    self.isChange = YES;
    if (self.ageStr == nil) {
        [self setDataValue];
    }
    [self dissMissPickView];
}

- (void)setDataValue
{
    ALConfigAgeBoxObject *ageBoxModel = self.model.ageBox.firstObject;
    self.ageStr = ageBoxModel.ageDisplay;
    self.ageCode = ageBoxModel.age;
}
#pragma mark -
#pragma mark -  数据源方法
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 1;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component
{
    return self.model.ageBox.count;
}

- (UIView *)pickerView:(UIPickerView *)pickerView viewForRow:(NSInteger)row forComponent:(NSInteger)component reusingView:(nullable UIView *)view
{
    ALConfigAgeBoxObject *ageBoxModel = self.model.ageBox[row];
    
    PickCellAgeView *pickCellView = [[PickCellAgeView alloc]init];
    
    pickCellView.ageStr = ageBoxModel.ageDisplay;
    
    return pickCellView;
}

#pragma mark -
#pragma mark -  代理方法
- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{    
    ALConfigAgeBoxObject *ageBoxModel = self.model.ageBox[row];
    
    self.ageStr = ageBoxModel.ageDisplay;

    self.ageCode = ageBoxModel.age;
}
#pragma mark -
#pragma mark - 屏幕点击事件
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [self dissMissPickView];
}

#pragma mark -
#pragma mark - 消失的方法
- (void)dissMissPickView
{
    if (self.ageBlock)
    {
        self.ageBlock(self.isChange, self.ageStr, self.ageCode);
    }
    __weak typeof (self)weakSelf = self;
    __weak typeof(UIView *)blockView = _toolsView;
    __weak typeof(UIPickerView *)blockPickerViwe = _picerView;
    [UIView animateWithDuration:0.3 animations:^{
        blockView.frame = CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, 44);
        blockPickerViwe.frame = CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, 200);
    }completion:^(BOOL finished) {
        [weakSelf removeFromSuperview];
    }];
}
- (ALConfigObject *)model
{
    if (!_model) {
        _model = [[ALConfigObject alloc] init];
    }
    return _model;
}

@end
