//
//  ALQAWebViewController.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/24.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALQAWebViewController.h"
#import "ALSetterUserInfoViewController.h"
#import "Alpha-Swift.h"
#import "AppDelegate+ViewControl.h"

@interface ALQAWebViewController ()<WKWebViewDelegate>
@end

@implementation ALQAWebViewController

- (void)initController {
    
    [super initController];
    
    // 多属性选择时需要隐藏导航栏，需要用到此属性
    self.controlNavigationByYou = NO;
    
    self.navigationBar.backgroundColor = [UIColor whiteColor];
    [self.navigationBar.rightButton setTitleColor:RGBCOLOR_HEX(0x999999) forState:UIControlStateNormal];
    self.navigationBar.isShowShadow = NO;
    self.navigationBar.rightTitle = @"跳过";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.webCompent.delegate = self;
    self.path = API_ALPHA_ASK;
    [self reloadURL];
}

- (void)rightButtonClicked:(OCNavigationBarButton *)button {

    NSString *textJS = @"window.hybrid.dispatcher.run('askSkipEvent')";
    [self.webCompent.webView evaluateJavaScript:textJS completionHandler:^(id response, NSError *error) {
        
        if (error) {
            debugLog(@"%s:%@",__func__,error);
            [[AppDelegate shareInstance] enableShowNextRootView:[ALQAWebViewController class]];
        }
    }];
}

- (void)backAction:(OCNavigationBarButton *)button {

    NSString *textJS = @"window.hybrid.dispatcherrun('askBackEvent')";
    [self.webCompent.webView evaluateJavaScript:textJS completionHandler:^(id response, NSError *error) {
        if (error) {
            debugLog(@"%s:%@",__func__,error);
            [super backAction:button];
        }
    }];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
