//
//  ALScanFaceCompleteViewController.m
//  GMAlpha
//
//  Created by Mikasa on 2018/12/11.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALScanFaceCompleteViewController.h"
#import "AppDelegate+ViewControl.h"

@interface ALScanFaceCompleteViewController ()
@property (nonatomic, strong) GMImageView *imageView;
@property (nonatomic, strong) GMLabel *titleLabel;
@property (nonatomic, strong) GMLabel *tipsLabel;
@property (nonatomic, strong) GMButton *nextButton;

@end

@implementation ALScanFaceCompleteViewController

- (GMImageView *)imageView {
    if (!_imageView) {
        GMImageView *imageView = [[GMImageView alloc] initWithImage:[UIImage imageNamed:@"scan_face_complete"]];
        _imageView = imageView;
    }
    if (!_imageView.superview) {
        [self.view addSubview:_imageView];
    }
    return _imageView;
}

- (GMLabel *)titleLabel {
    if (!_titleLabel) {
        GMLabel *titleLabel = [GMLabel new];
        titleLabel.text = @"已扫脸成功！";
        titleLabel.textColor = RGBCOLOR_HEX(0x282828);
        titleLabel.font = [UIFont gmBoldFont:20];
        titleLabel.textAlignment = NSTextAlignmentCenter;
        _titleLabel = titleLabel;
    }
    if (!_titleLabel.superview) {
        [self.view addSubview:_titleLabel];
    }
    return _titleLabel;
}

- (GMLabel *)tipsLabel {
    if (!_tipsLabel) {
        GMLabel *tipsLabel = [GMLabel new];
        tipsLabel.text = [GMLoginManager shareInstance].user.has_scanFace ? @"查看3D效果" : @"请完成问卷,查看3D效果";
        tipsLabel.textColor = RGBCOLOR_HEX(0x666666);
        tipsLabel.font = [UIFont gmFont:14];
        tipsLabel.textAlignment = NSTextAlignmentCenter;
        _tipsLabel = tipsLabel;
    }
    if (!_tipsLabel.superview) {
        [self.view addSubview:_tipsLabel];
    }
    return _tipsLabel;
}

- (GMButton *)nextButton {
    if (!_nextButton) {
        GMButton *nextButton = [GMButton new];
        [nextButton setTitle:@"下一步" forState:UIControlStateNormal];
        [nextButton addTarget:self action:@selector(nextButtonClick) forControlEvents:UIControlEventTouchUpInside];
        [nextButton setTitleColor:RGBCOLOR_HEX(0xFFFFFF) forState:UIControlStateNormal];
        [nextButton setBackgroundColor:RGBCOLOR_HEX(0x0093FF) forState:UIControlStateNormal];
        nextButton.layer.masksToBounds = YES;
        nextButton.layer.cornerRadius = 20.0f;
        _nextButton = nextButton;
    }
    if (!_nextButton.superview) {
        [self.view addSubview:_nextButton];
    }
    return _nextButton;
}

- (void)nextButtonClick {
    
    [Phobos track:@"face_scan_click_next_step" attributes:@{@"page_name":@"face_scan_success"}];
    
    [GMLoginManager shareInstance].user.has_scanFace = YES;
    [[GMLoginManager shareInstance] saveUser];
    [[AppDelegate shareInstance] enableShowNextRootView:[ALScanFaceHomeViewController class]];

}

- (void)initController {
    
    [super initController];
    
    self.pageName = @"face_scan_success";
    // 多属性选择时需要隐藏导航栏，需要用到此属性
    self.controlNavigationByYou = NO;
    
    self.navigationBar.backgroundColor = [UIColor colorWithWhite:0 alpha:0];
    self.navigationBar.titleLabel.textColor = RGBCOLOR_HEX(0x282828);
    self.navigationBar.isShowShadow = NO;
    
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.navigationBar.title = @"模拟";
    [self setupSubView];
}

- (void)setupSubView {
    
    CGFloat space = MIN((OCNavigationBar.barHeight + 59), ((MAINSCREEN_HEIGHT - 124 - 28 - 20 - 12 - 14)/2));
    
    __weak __typeof(self)weakSelf = self;
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(space);
        make.width.height.mas_equalTo(124);
        make.centerX.mas_equalTo(weakSelf.view.mas_centerX);
    }];
    
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_imageView.mas_bottom).offset(28);
        make.height.mas_equalTo(20);
        make.left.right.mas_equalTo(0);
    }];
    
    [self.tipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_titleLabel.mas_bottom).offset(12);
        make.height.mas_equalTo(14);
        make.left.right.mas_equalTo(0);
    }];
    
    [self.nextButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(-(UIView.safeAreaInsetsBottom + 20));
        make.height.mas_equalTo(41);
        make.left.mas_equalTo(30);
        make.right.mas_equalTo(-30);
    }];
}
@end
