//
//  ALScanFaceHomeViewController.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/23.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALScanFaceHomeViewController.h"
#import <Unre2DScanLib/U2DCamera.h>
#import <UnreScanLib/U3DCamera.h>
#import "UIView+SafeArea.h"
#import "ALUnre2DViewController.h"
#import "AL3DCaptureController.h"
#import "ALScanManager.h"
#import "ALFaceFittingAPI.h"
#import "AppDelegate+ViewControl.h"
#import <Unre2DScanLib/U2DCamera.h>
#import "ALScanPlayerView.h"


@interface ALScanFaceHomeViewController ()

@property (nonatomic, strong) GMButton *jumpSinInButton;

@end

@implementation ALScanFaceHomeViewController

- (void)initController {
    
    [super initController];
    
    self.pageName = @"face_scan_guide";
    // 多属性选择时需要隐藏导航栏，需要用到此属性
    self.controlNavigationByYou = NO;
    
    self.navigationBar.backgroundColor = [UIColor colorWithWhite:0 alpha:0];
    self.navigationBar.titleLabel.textColor = RGBCOLOR_HEX(0xFFFFFF);
    self.navigationBar.isShowShadow = NO;
    
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.navigationBar.title = @"模拟";
    [self setupSubView];
    
    // 当前用户只在启动展示一次
    [GMLoginManager shareInstance].user.has_scanFace = YES;
    [[GMLoginManager shareInstance] saveUser];
    [[NSUserDefaults standardUserDefaults] setObject:@([GMLoginManager shareInstance].user.has_scanFace) forKey:kShowScanFace];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

- (void)backAction:(OCNavigationBarButton *)button {
    [super backAction:button];
    
    [Phobos track:@"page_click_return_label" attributes:@{@"page_name":self.pageName}];
}

- (void)setIsHiddenJump:(BOOL)isHiddenJump {
    _isHiddenJump = isHiddenJump;
    if (isHiddenJump) {
        _jumpSinInButton.hidden = YES;
    }
}

- (void)setupSubView {
    
    GMImageView *imageView = [GMImageView new];
    imageView.contentMode = UIViewContentModeScaleAspectFill;
    imageView.image = [UIImage imageNamed:@"signIn_bg"];
    [self.view addSubview:imageView];
    [imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.top.bottom.mas_equalTo(0);
    }];
    GMLabel *titleLabel = [GMLabel labelWithTextAlignment:NSTextAlignmentCenter backgroundColor:UIColor.clearColor textColor:RGBCOLOR_HEX(0xFFFFFF) fontSize:19];
    titleLabel.numberOfLines = 0;
    titleLabel.text = @"前置摄像头\n动图引导用户左右摆头完成扫描";
    [self.view addSubview:titleLabel];
    
    
    // 完成
    GMButton *beginButton = [GMButton buttonWithTitle:@"开始扫描" backgroundColor:RGBCOLOR_HEX(0x0093FF) titleFontSize:16 titleColor:UIColor.whiteColor];
    [beginButton addTarget:self action:@selector(beginButtonClick) forControlEvents:UIControlEventTouchUpInside];
    beginButton.layer.masksToBounds = YES;
    beginButton.layer.cornerRadius = 20.0f;
    [self.view addSubview:beginButton];
    
    if (!_isHiddenJump) {
        GMButton *jumpSinInButton = [GMButton new];
        NSMutableAttributedString *jumpSinInAtti = [NSAttributedString attributedStringWithString:@"跳过" font:[UIFont gmFont:12] color:RGBCOLOR_HEX(0xFFFFFF)];
        [jumpSinInAtti addAttribute:NSUnderlineStyleAttributeName
                              value:@(NSUnderlineStyleSingle)
                              range:NSMakeRange(0, jumpSinInAtti.length)];
        [jumpSinInButton setAttributedTitle:jumpSinInAtti forState:UIControlStateNormal];
        [jumpSinInButton addTarget:self action:@selector(jumpSinInButtonClick) forControlEvents:UIControlEventTouchUpInside];
        [self.view addSubview:jumpSinInButton];
        
        [jumpSinInButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.mas_equalTo(-(UIView.safeAreaInsetsBottom +15));
            make.width.mas_equalTo(100);
            make.centerX.mas_equalTo(self.view.mas_centerX);
            make.height.mas_equalTo(12 + 10);
        }];
    }
    
    
    [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(54);
        make.bottom.mas_equalTo(beginButton.mas_top).offset(-30);
    }];
    
    [beginButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(30);
        make.right.mas_equalTo(-30);
        make.height.mas_equalTo(40);
        make.bottom.mas_equalTo(-(UIView.safeAreaInsetsBottom +45));
    }];
    
}

// 开始扫描
- (void)beginButtonClick {
    [Phobos track:@"face_scan_guide_click_begin_scan" attributes:@{@"page_name":self.pageName}];
    AVAuthorizationStatus authStatus = [AVCaptureDevice authorizationStatusForMediaType:AVMediaTypeVideo];
    if (authStatus == AVAuthorizationStatusRestricted || authStatus ==AVAuthorizationStatusDenied) {
        UIAlertAction *action = [UIAlertAction actionWithTitle:@"我知道了" style:UIAlertActionStyleCancel handler:nil];
        UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"温馨提示" message:@"请您先去设置允许APP访问您的相机 设置>隐私>相机" preferredStyle:UIAlertControllerStyleAlert];
        [alert addAction:action];
        [self presentViewController:alert animated:YES completion:nil];
        
    } else {
        [GMHudModule showLoading:@"正在为您准备扫描数据～"];
         __weak __typeof(self)weakSelf = self;
        [ALFaceFittingAPI fetchFaceFittingDataWithCompletion:^(GMResponseOC *responseObject) {
            [GMHudModule hideLoading];
            [self toast:responseObject.message];
            if (responseObject.isSuccess) {
                [weakSelf jumpScanController];
            } else {
                
            }
        }];
    }
    
}
 - (void)jumpScanController {
     if (@available(iOS 11.0, *)) {
         // iphoneX 以上 11.0 系统下会crash
         Unre3DCamera *camera = [[Unre3DCamera alloc] initWithVideoOrientation:Unre3DCameraVideoOrientationPortraitUp];
         if (camera.supportsDepthDataCapturing) {
             AL3DCaptureController *controller = [[AL3DCaptureController alloc] init];
             ALScanManager.shareInstance.capture3Dvc = controller;
             ALScanManager.shareInstance.isScan3D = YES;
             [self pushViewController:controller];
         } else {
             ALUnre2DViewController *controller =[[ALUnre2DViewController alloc] init];
             ALScanManager.shareInstance.capture2Dvc = controller;
             [self pushViewController:controller];
         }
     } else {
         ALUnre2DViewController *controller =[[ALUnre2DViewController alloc] init];
         ALScanManager.shareInstance.capture2Dvc = controller;
         [self pushViewController:controller];
     }
 }

// 跳过
- (void)jumpSinInButtonClick {
    
    [Phobos track:@"face_scan_guide_click_skip_scan" attributes:@{@"page_name":self.pageName}];
    
    [GMLoginManager shareInstance].user.has_scanFace = YES;
    [[GMLoginManager shareInstance] saveUser];
    [[AppDelegate shareInstance] enableShowNextRootView:[ALScanFaceHomeViewController class]];
}


@end
