//
//  ALProtocolButton.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/21.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALProtocolView.h"
#import "WMBaseWebViewController.h"

@interface ALProtocolView()
@property (nonatomic, strong) GMButton *protocolButton;

@end

@implementation ALProtocolView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self setupSubView];
    }
    return self;
}

- (void)setupSubView {
    
    GMButton *agreeButton = [GMButton new];
    [agreeButton setImage:[UIImage imageNamed:@"unselected_icon"] forState:UIControlStateNormal];
    [agreeButton setImage:[UIImage imageNamed:@"sign_selected_icon"] forState:UIControlStateSelected];
    [agreeButton addTarget:self action:@selector(agreeButtonClick) forControlEvents:UIControlEventTouchUpInside];
    agreeButton.selected = YES;
    [self addSubview:agreeButton];
    self.agreeButton = agreeButton;
    
    GMButton *protocolButton = [GMButton new];
    [protocolButton setTitle:@"同意注册协议" forState:UIControlStateNormal];
    [protocolButton setTitleColor:RGBCOLOR_HEX(0xDFDFDF) forState:UIControlStateNormal];
    [protocolButton setTitleColor:RGBCOLOR_HEX(0xFFFFFF) forState:UIControlStateSelected];
    protocolButton.titleLabel.font = [UIFont gmFont:12];
    protocolButton.frame = CGRectMake(0, 0, 80, 15);
    [protocolButton addTarget:self action:@selector(protocolButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:protocolButton];
    self.protocolButton = protocolButton;
    
    __weak __typeof(self)weakSelf = self;
    [self.agreeButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(20, 20));
        make.centerY.mas_equalTo(weakSelf.mas_centerY);
    }];
    
    [self.protocolButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(weakSelf.agreeButton.mas_right);
        make.top.bottom.right.mas_equalTo(0);
    }];
}

- (void)agreeButtonClick {
    
    self.agreeButton.selected = !self.agreeButton.isSelected;
    self.protocolButton.selected = self.agreeButton.isSelected;
}

- (void)protocolButtonClick {
    WMBaseWebViewController *webViewCtrl = [WMBaseWebViewController new];
    webViewCtrl.path = @"/alpha/register-agreement";
    [[AppDelegate navigation] pushViewController:webViewCtrl animated:YES];
}

@end
