//
//  ALRegisterSetPwdView.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/13.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALRegisterSetPwdView.h"
#import "ALLoginViewController.h"
#import "GMSignInManager.h"
#import "ALQAWebViewController.h"
#import "AppDelegate+ViewControl.h"


@interface ALRegisterSetPwdView()<UITextFieldDelegate>
@property (nonatomic, strong) GMButton *eventButton;// 操作按钮
@property (nonatomic, strong) GMTextField *setPwdField;// 密码设置
@end

@implementation ALRegisterSetPwdView
- (instancetype)init {
    if (self = [super init]) {
        
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(textChange:) name:UITextFieldTextDidChangeNotification object:self.setPwdField];
    }
    return self;
}


- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)setup {
    [super setup];
    
    GMTextField *setPwdField = [GMTextField new];
    setPwdField.placeholder = @"请设置一个密码";
    setPwdField.secureTextEntry = YES;
    setPwdField.delegate = self;
    [self addSubview:setPwdField];
    
    UIView *leftView = [[UIView alloc] initWithFrame:CGRectMake(0, 5, 15, 20)];
    GMImageView *iconImageView = [[GMImageView alloc] initWithFrame:CGRectMake(0, 0, 17, 20)];
    iconImageView.contentMode = UIViewContentModeScaleToFill;
    iconImageView.image = [UIImage imageNamed:@"register_setpwd_icon"];
    [leftView addSubview:iconImageView];
    setPwdField.leftView = leftView;
    setPwdField.leftViewMode = UITextFieldViewModeAlways;
    
    [setPwdField addBottomLine];
    self.setPwdField = setPwdField;
    
    
    
    // 注册
    GMButton *eventButton = [GMButton new];
    eventButton.titleLabel.font = [UIFont gmFont:16];
    eventButton.titleLabel.textAlignment = NSTextAlignmentCenter;
    [eventButton setTitle:@"注册" forState:UIControlStateNormal];
    [eventButton addTarget:self action:@selector(eventButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [eventButton setTitleColor:RGBCOLOR_HEX(0xFFFFFF) forState:UIControlStateNormal];
    [eventButton setBackgroundColor:RGBCOLOR_HEX(0x0093FF) forState:UIControlStateNormal];
    [eventButton setBackgroundColor:[UIColor colorWithHex:0x0093FF alpha:0.4] forState:UIControlStateDisabled];
    eventButton.layer.masksToBounds = YES;
    eventButton.layer.cornerRadius = 20.0f;
    eventButton.enabled = NO;
    [self addSubview:eventButton];
    self.eventButton = eventButton;
    
    [self addSubViewContraints];
}

- (void)addSubViewContraints {
    [self.setPwdField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(35);
        make.left.mas_equalTo(30);
        make.right.mas_equalTo(-30);
        make.height.mas_equalTo(56);
    }];
    
    [self.eventButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(-(UIView.safeAreaInsetsBottom+20));
        make.left.mas_equalTo(22);
        make.right.mas_equalTo(-22);
        make.height.mas_equalTo(41);
    }];
}

- (void)eventButtonClick {
    
    [self endEditing:YES];
    if (![self.setPwdField.text isNonEmpty]) {
        [GMHudModule toast:@"密码不能为空"];
        [self.setPwdField becomeFirstResponder];
        return;
    }
    [GMSignInManager registerWithAccount_type:ALSignInTypeEmail vfcType:self.code email:self.userName phone:@"" pwd:self.setPwdField.text finishBlock:^(NSString *message, BOOL success, id data) {
        
        if (success) {
            [GMHudModule showComplete:@"登录成功"];
        } else {
            [GMHudModule toast:message];
        }
    }];
}

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    
    [self endEditing:YES];
}


#pragma mark - UITextFieldDelegate
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    NSString *text = textField.text;
    if (![text isNonEmpty]) {
        return NO;
    }
    
    [textField resignFirstResponder];
    return YES;
}

#pragma mark - NSNotificationCenter
- (void)textChange:(NSNotification *)notifi {
    
    [self eventButtonEnable];
}

- (void)eventButtonEnable {
    
    if ([self.setPwdField.text isNonEmpty]) {
        self.eventButton.enabled = YES;
    } else {
        self.eventButton.enabled = NO;
    }
}

@end
