//
//  ALSignInView.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/13.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALSignInHomeView.h"
#import "ALRegisterViewController.h"
#import "GMSignInManager.h"
#import "ALProtocolView.h"
#import "ALQAWebViewController.h"
#import "AppDelegate+ViewControl.h"
#import "WMBaseWebViewController.h"
#import "GMShareSDK.h"

@interface ALSignInHomeView()

@property (nonatomic, strong) GMView *sinInTypeView;// 其他登录
@property (nonatomic, strong) GMButton *sinInButton;// 注册/登录按钮
@property (nonatomic, strong) GMButton *jumpSinInButton;//跳过注册
@property (nonatomic, strong) ALProtocolView *protocolView;// 同意协议

@end
@implementation ALSignInHomeView

- (void)setup {
    
    [super setup];
    
    
    // 类型
    GMView *sinInTypeView = [GMView new];
    [self addSubview:sinInTypeView];
    self.sinInTypeView = sinInTypeView;
    
    // 注册登录
    GMButton *sinInButton = [GMButton new];
    sinInButton.titleLabel.font = [UIFont gmBoldFont:17];
    sinInButton.titleLabel.textAlignment = NSTextAlignmentCenter;
    [sinInButton setTitle:@"注册/登录" forState:UIControlStateNormal];
    [sinInButton setTitleColor:RGBCOLOR_HEX(0xFFFFFF) forState:UIControlStateNormal];
    [self addSubview:sinInButton];
    self.sinInButton = sinInButton;
    
    // 同意注册协议
    ALProtocolView *protocolView = [ALProtocolView new];
    [self addSubview:protocolView];
    self.protocolView = protocolView;
    
    // 跳过注册
    GMButton *jumpSinInButton = [GMButton new];
    NSMutableAttributedString *jumpSinInAtti = [NSAttributedString
                                                attributedStringWithString:@"跳过"
                                                font:[UIFont gmFont:12] color:RGBCOLOR_HEX(0xFFFFFF)];
    NSMutableParagraphStyle *style = [[NSMutableParagraphStyle alloc] init];
    style.alignment = NSTextAlignmentCenter;
    
    [jumpSinInAtti addAttribute:NSUnderlineStyleAttributeName
                          value:@(NSUnderlineStyleSingle)
                          range:NSMakeRange(0, jumpSinInAtti.length)];
    [jumpSinInAtti addAttribute:NSParagraphStyleAttributeName
                      value:style
                      range:NSMakeRange(0, jumpSinInAtti.length)];
    [jumpSinInButton setAttributedTitle:jumpSinInAtti forState:UIControlStateNormal];
    [jumpSinInButton addTarget:self action:@selector(jumpSinInButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:jumpSinInButton];
    self.jumpSinInButton = jumpSinInButton;
    
    [self addSubViewConstraints];
    
    [self addSinInTypeSubView];
    
}

- (void)addSubViewConstraints {
    
    __weak __typeof(self)weakSelf = self;
    [self.protocolView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(-(UIView.safeAreaInsetsBottom + 15));
        make.width.mas_equalTo(100);
        make.centerX.mas_equalTo(weakSelf.mas_centerX);
        make.height.mas_equalTo(17 + 10);
    }];
    
    [self.jumpSinInButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(_protocolView.mas_top).offset(-20);
        make.width.mas_equalTo(100);
        make.centerX.mas_equalTo(weakSelf.centerX);
        make.height.mas_equalTo(12 + 10);
    }];
    
    [self.sinInTypeView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(100);
        make.centerX.mas_equalTo(weakSelf.centerX);
        make.height.mas_equalTo(50);
        make.bottom.mas_equalTo(_jumpSinInButton.mas_top).offset(-15);
    }];
    
    [self.sinInButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.bottom.mas_equalTo(_sinInTypeView.mas_top).offset(-10);
        make.height.mas_equalTo(22);
    }];
}

#pragma mark - addSinInTypeSubView
- (void)addSinInTypeSubView {
    
    [self addSinInType:GMSharePlatformQQ];
    if ([GMShareSDK isClientInstalled:GMSharePlatformWechat] ) {
        [self addSinInType:GMSharePlatformWechat];
    }
    [self addSinInType:GMSharePlatformEmail];
    
    NSInteger count = self.sinInTypeView.subviews.count;
    CGFloat sinInTypeViewW = (50 + 35) *count - 35;
    [self.sinInTypeView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(sinInTypeViewW);
    }];
    
    for (int i = 0; i < count; i++) {
        GMButton *button = self.sinInTypeView.subviews[i];
        if (i == 0) {
            [button mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.top.mas_equalTo(0);
                make.size.mas_equalTo(CGSizeMake(50, 50));
            }];
        } else {
            GMButton *prebutton = self.sinInTypeView.subviews[i-1];
            [button mas_makeConstraints:^(MASConstraintMaker *make) {
                make.top.mas_equalTo(0);
                make.size.mas_equalTo(CGSizeMake(50, 50));
                make.left.mas_equalTo(prebutton.mas_right).offset(35);
            }];
        }
    }
}

- (void)addSinInType:(GMSharePlatform)type {
    
    NSString *iconString = @"";
    if (type == GMSharePlatformQQ) {
        iconString = @"qq_login";
    } else if (type == GMSharePlatformWechat) {
        iconString = @"weixin_login";
    } else {
        iconString = @"email_login";
    }
    GMButton *button = [GMButton new];
    button.tag = 1000 + type;
    [button setImage:[UIImage imageNamed:iconString] forState:UIControlStateNormal];
    [button addTarget:self action:@selector(sinInTypeClick:) forControlEvents:UIControlEventTouchUpInside];
    [self.sinInTypeView addSubview:button];
}

// 其他平台
- (void)sinInTypeClick:(GMButton *)sender {
    
    GMSharePlatform type = sender.tag - 1000;
    [Phobos track:@"splash_screen_click_login" attributes:@{@"type":[self loginType:type]}];
    
    if (!self.protocolView.agreeButton.selected) {
        
        [GMHudModule toast:@"请先同意注册协议"];
        return;
    }
    
    if (type == GMSharePlatformEmail) {
        
        [self sinInButtonClick];
    } else {
        
        [GMSignInManager loginWithType:type finishBlock:^(NSString *message, BOOL success, id data) {

            [GMHudModule toast:message];
        }];
    }
}

- (NSString *)loginType:(GMSharePlatform)type {
    if (type ==  GMSharePlatformWechat) {
        return @"微信";
    } else if (type ==  GMSharePlatformQQ) {
        return @"QQ";
    } else if (type ==  GMSharePlatformEmail) {
        return @"邮箱";
    }
    return @"";
}
// 注册 登陆按钮
- (void)sinInButtonClick {
    
    ALRegisterViewController *registerCtrl = [[ALRegisterViewController alloc] init];
    [[AppDelegate navigation] pushViewController:registerCtrl animated:YES];
}

// 跳过注册按钮
- (void)jumpSinInButtonClick {
    
    [Phobos track:@"splash_screen_click_skip_register"];
    
    [[AppDelegate shareInstance] enableShowNextRootView:[ALSignInViewController class]];
}

@end
