//
//  ALLoginViewController.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/12.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALLoginViewController.h"
#import "ALSignInView.h"

@interface ALLoginViewController ()
@property (nonatomic, strong) ALSignInView *signInView;
@end

@implementation ALLoginViewController

- (ALSignInView *)signInView {
    if (!_signInView) {
        ALSignInView *signInView = [ALSignInView new];
        signInView.signInEvent = ALSignInEventLogin;
        _signInView = signInView;
    }
    if (!_signInView.superview) {
        [self.view addSubview:_signInView];
    }
    return _signInView;
}

- (void)initController {
    
    [super initController];
    
    self.pageName = @"login";
    // 多属性选择时需要隐藏导航栏，需要用到此属性
    self.controlNavigationByYou = NO;
    
    self.navigationBar.backgroundColor = [UIColor colorWithWhite:0 alpha:0];
    self.navigationBar.titleLabel.textColor = [UIColor colorWithWhite:0 alpha:0];
    self.navigationBar.isShowShadow = NO;
    
}

- (void)viewDidLoad {
    
    [super viewDidLoad];
    
    self.navigationBar.title = @"";
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    [self.signInView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.top.mas_equalTo(0);
        make.bottom.mas_equalTo(0);
    }];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
