//
//  ALRegisterSetPwdViewController.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/13.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALRegisterSetPwdViewController.h"
#import "ALRegisterSetPwdView.h"
#import "UIView+SafeArea.h"

@interface ALRegisterSetPwdViewController ()
@property (nonatomic, strong) ALRegisterSetPwdView *setPwdView;
@end

@implementation ALRegisterSetPwdViewController

- (ALRegisterSetPwdView *)setPwdView {
    if (!_setPwdView) {
        ALRegisterSetPwdView *setPwdView = [ALRegisterSetPwdView new];
        _setPwdView = setPwdView;
    }
    if (!_setPwdView.superview) {
        [self.view addSubview:_setPwdView];
    }
    return _setPwdView;
}

- (void)initController {
    [super initController];
    self.viewModel = [[ALSignInViewModel alloc] init];
}

- (void)viewDidLoad {
    
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.view.backgroundColor = [UIColor whiteColor];
    self.navigationBar.title = @"注册";
    self.setPwdView.code = self.viewModel.vfc_code;
    self.setPwdView.userName = self.viewModel.email;
    [self.setPwdView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.top.mas_equalTo(self.navigationBar.height);
        make.bottom.mas_equalTo(0);
    }];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
