//
//  ALSignInViewController.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/12.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALSignInViewController.h"
#import "ALSignInHomeView.h"
#import "UIView+SafeArea.h"

@interface ALSignInViewController ()

@property (nonatomic, strong) ALSignInHomeView *sinInView;
@property (nonatomic, strong) GMImageView *imageView;
@property (nonatomic, strong) GMButton *backButton;

@end

@implementation ALSignInViewController
#pragma mark - lazy loading
- (ALSignInHomeView *)sinInView {
    if (!_sinInView) {
        ALSignInHomeView *sinInView = [ALSignInHomeView new];
        _sinInView = sinInView;
    }
    if (!_sinInView.superview) {
        [self.view addSubview:_sinInView];
    }
    return _sinInView;
}

- (GMButton *)backButton {
    if (!_backButton) {
        GMButton *backButton = [GMButton new];
        [backButton setBackgroundImage:[UIImage imageNamed:@"launch_dismiss"] forState:UIControlStateNormal];
        [backButton addTarget:self action:@selector(backButtonClick) forControlEvents:UIControlEventTouchUpInside];

        _backButton = backButton;
    }
    if (!_backButton.superview) {
        [self.view addSubview:_backButton];
    }
    return _backButton;
}

- (void)initController {
    [super initController];
    self.pageName = @"splash_screen";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.controlNavigationByYou = true;
    self.navigationBar.hidden = true;
    
    // Do any additional setup after loading the view.
    GMImageView *imageView = [GMImageView new];
    imageView.image = [UIImage imageNamed:@"signIn_bg"];
    [self.view addSubview:imageView];
    self.imageView = imageView;
    
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.top.mas_equalTo(0);
        make.bottom.mas_equalTo(0);
    }];
    
    [self.sinInView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.top.mas_equalTo(0);
        make.top.bottom.mas_equalTo(0);
    }];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)backButtonClick {
    [[AppDelegate navigation] popViewControllerAnimated:YES];
}

@end
