//
//  AppDelegate+Networking.swift
//  Gengmei
//
//  Created by licong on 16/8/9.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

import UIKit
//import GMBaseSwift
import GMNetworking

/// 推送类型, 埋点使用
var pushType = ""
/// 是否弹出, 针对当前app启动
var hasPushCurrent = false

@objc extension AppDelegate: GMCommonAlertViewDelegate {
    func setupNetworking() {
        GMNetworking.netErrorMsg = "网络错误"
        GMNetworking.apiHost = GMServerDomains.apiHost
        GMNetworking.urlCommonParameters = self.urlCommonParameters()
        GMNetworking.responseInterception = { (json, response) in
            guard let dict = json as NSDictionary? else {
                return
            }
            
            self.responseInterception(dict: dict)
        }
        
        GMNetworking.requestInterception = { request in
            var newReq = request

            // cookie 加密
            for (key, value) in GMCookieManager.requestHeaderFields() {
                newReq.setValue(value, forHTTPHeaderField: key)
            }
            return newReq
        }

    }
    
    func responseInterception(dict: NSDictionary) {

        //zhb...调试首页接口,注释掉的..
//        if let a = dict["user_type"] as? [AnyHashable: Any] {
//            let userType = NSMutableDictionary(dictionary: a)
//            Phobos.sharedClient().userType = userType
//        }
        
//        if let a = dict["extra"] as? [AnyHashable: Any] {
//            let extra = NSDictionary(dictionary: a)
////            self.showPointAlert(extra)
//        }

        /// 未实名认证的code==70006，发送一个弹出认证页面的通知
        if let error = dict["error"] as? Int, error == 70006 {
//            NotificationCenter.default.post(name: Notification.Name(rawValue: PHONE_AUTHENTICATION), object: nil)
        }
    }

//    /// 场景化弹窗
//    func showAlertView(_ obj: GMExtraObject) {
//        let alerView = GMPointAlertView()
//        alerView.titleLabel.text = obj.extraData.title
//        alerView.subTitleLabel.text = obj.extraData.subTitle
//        alerView.showPointAlert()
//    }
    
    /// push授权弹窗
//    func showPushAlertView(_ obj: GMExtraObject) {
//        // 有键盘的需要收起键盘
//        AppDelegate.visibleController.view.endEditing(true)
//        // 拿取之前弹过弹窗的类型
//        let storeTypes: [String] = GMCache.fetchObject(atDocumentPathWithkey: kShowPushNotifyAlertTypes) as? [String] ?? []
//        var types: Array = storeTypes
//        types.append(pushType)
//        // 存储弹出的类型数组
//        GMCache.storeObject(atDocumentPathWithkey: kShowPushNotifyAlertTypes, object: types as NSCoding)
//
//        hasPushCurrent = true
//        let pushAlertView = GMCommonAlertView()
//        pushAlertView.delegate = self
//        pushAlertView.titleLabel.text = obj.generalAdditionalData.title
//        pushAlertView.subLabel.text = obj.generalAdditionalData.subTitle
//        pushAlertView.show()
//        Phobos.track("open_notification_push_item", attributes: ["business_type": "notification_push",
//                                                                 "trigger_event": pushType])
//    }
    
    func didClickCommonAlert(buttonIndex: Int, alertView: GMCommonAlertView) {
        alertView.dismiss()
        if buttonIndex == 1 {
            if GMCache.fetchObject(atDocumentPathWithkey: "kHasShowSystemPushAuthorizeNotification") == nil {
                // 没有弹起过系统通知框
//                AppDelegate.shareInstance().setupJPushNotification()
            } else {
                AppDelegate.visibleController.goToAppSystemSettings()
            }
            Phobos.track("open_notification_click_item", attributes: ["item_name": "确定打开", "trigger_event": pushType])
        } else if buttonIndex == 2 {
            Phobos.track("open_notification_click_item", attributes: ["item_name": "不用打开", "trigger_event": pushType])
        } else {
            GMCache.storeObject(atDocumentPathWithkey: "kShowPushNotifyAlert", object: "1" as NSCoding)
            Phobos.track("open_notification_click_item", attributes: ["item_name": "不再提醒", "trigger_event": pushType])
        }
    }

}
