//
//  AppDelegate+ViewControl.m
//  Gengmei
//
//  Created by 翟国钧 on 16/3/22.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import "AppDelegate+ViewControl.h"
#import <objc/runtime.h>
#import "GMModalFadeInOutAnimator.h"
//#import "Gengmei-Swift.h"
//#import "GMLaunchManager.h"
#import "GMTabBarController.h"
#import <Bugly/Bugly.h>

/**
 为了便于
 */
@interface GMWindowRootInfo : NSObject
@property (nonatomic, copy) NSString *key;


/**
 在切换controller时如果需要做动画
 */
@property (nonatomic, copy) void (^animation)(UIView *);

/**
 是否需要显示该controller
 */
@property (nonatomic, copy) BOOL (^shouldDisplay)(void);

/**
 在需要显示情况下，使用该闭包创建controller
 */
@property (nonatomic, copy) UIViewController * (^createController)(void);

@end
@implementation GMWindowRootInfo
- (void)dealloc {
    
}
@end

@interface AppDelegate ()
/**
 *  @author wangyang, 16-10-14 17:04:58
 *
 *  按顺序存放的 rootController
 *  @since 6.5.0
 */
@property (nonatomic, readonly, nonnull) NSMutableArray<GMWindowRootInfo *> *rootInfos;
@end

@implementation AppDelegate (ViewControl)

- (NSMutableArray<GMWindowRootInfo *> *)rootInfos {
    NSMutableArray<GMWindowRootInfo *> *_infos = objc_getAssociatedObject(self, @selector(rootInfos));
    if (_infos) {
        return _infos;
    } else {
        NSMutableArray *_infos = [NSMutableArray<GMWindowRootInfo *> array];
        self.rootInfos = _infos;
        return _infos;
    }
}

- (void)setRootInfos:(NSMutableArray<GMWindowRootInfo *> * _Nonnull)rootInfos {
    objc_setAssociatedObject(self, @selector(rootInfos), rootInfos, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

/**
 有序的使用该方法创建 WindowRootInfo，使用showNextRootView方法让app切换到下一个WindowRootInfo
 @param animation 暂未使用
 */
- (void)shouldDisplay:(BOOL (^)(void))shouldDisplay controller:(UIViewController * (^)(void))createController withAnimation:(void (^)(UIView *))animation key:(NSString *)key {
    
    GMWindowRootInfo *info = [self rootInfo:shouldDisplay controller:createController withAnimation:animation key:key];
    [self.rootInfos addObject:info];
}

- (GMWindowRootInfo *)rootInfo:(BOOL (^)(void))shouldDisplay controller:(UIViewController * (^)(void))createController withAnimation:(void (^)(UIView *))animation key:(NSString *)key {
    GMWindowRootInfo *info = [GMWindowRootInfo new];
    info.shouldDisplay = shouldDisplay;
    info.createController = createController;
    info.animation = animation;
    info.key = key;
    return info;
}

#pragma mark - 视图管理
- (void)configWindowRootController {
    
    // 展示引导流程
    [self configGuideRootView];
    
    // 主视图最后加上
    [self addTabBarController];

    // 启动第一个controller
    [self showNextRootView];
}

// 展示引导流程
- (void)configGuideRootView {
    
    [self.rootInfos removeAllObjects];
    
    // 未登录展示登录页面
    [self shouldDisplay:^BOOL{
        return [GMLoginManager shareInstance].isVisitor;
    } controller:^UIViewController *{
        return [ALSignInViewController new];
    } withAnimation:nil key:@"sign"];
    
    // 未进行扫脸操作展示扫脸
    [self shouldDisplay:^BOOL{
        return (![GMLoginManager shareInstance].user.has_scanFace);
    } controller:^UIViewController *{
        return [ALScanFaceHomeViewController new];
    } withAnimation:nil key:@"scanFace"];
    
    // 用户未答题进入答题页面
    [self shouldDisplay:^BOOL{
        return (![GMLoginManager shareInstance].user.has_answered);
    } controller:^UIViewController *{
        return [ALQAWebViewController new];
    } withAnimation:nil key:@"ask"];
    
    // 用户未设置过用户信息进入用户信息设置页面
    [self shouldDisplay:^BOOL{
        return (![GMLoginManager shareInstance].user.detail_setted);
    } controller:^UIViewController *{
        return [ALSetterUserInfoViewController new];
    } withAnimation:nil key:@"setterUser"];
}

- (void)showNextRootView {

    // debugInfo 是用来调试线上问题的。见下方代码“showNextRootView数组越界”，当没有该问题时，就可以删除掉了。
    NSMutableArray *debugInfo = [NSMutableArray array];
    for (GMWindowRootInfo *info in self.rootInfos) {
        [debugInfo addObject:info.key];
    }
    do {
        // 异常情况。如果某种未预料的情况下，什么也不做
        if (self.rootInfos.count == 0) {
            NSDictionary *dic = @{@"controller": SafeString(NSStringFromClass([AppDelegate.visibleController class])),
                                  @"debugInfo": debugInfo
                                  };
            [Bugly reportException:[NSException exceptionWithName:@"showNextRootView数组越界" reason:@"" userInfo:dic]];
            AppDelegate.navigation.viewControllers = @[[GMTabBarController new]];
            return;
        }
        GMWindowRootInfo *info = self.rootInfos[0];
        if (info.shouldDisplay()) {
            AppDelegate.navigation.viewControllers = @[info.createController()];
            [self.rootInfos removeObjectAtIndex:0];
            break;
        } else {
            [self.rootInfos removeObjectAtIndex:0];
            continue;
        }
    } while (self.rootInfos.count > 0);
}

/**
 *  @brief  显示应用主页
 */
- (void)showHomeView {
    
    [self.rootInfos removeAllObjects];
    [self addTabBarController];
    [self showNextRootView];
}

- (void)addTabBarController {
    [self shouldDisplay:^BOOL{
        return YES;
    } controller:^UIViewController *{
        return [GMTabBarController new];
    } withAnimation:nil key:@"TabBar"];
}

// 重新展示为RootView
- (void)reloadShowRoowView:(UIViewController *)viewCtrl {
    
    [self shouldDisplay:^BOOL{
        return YES;
    } controller:^UIViewController *{
        return viewCtrl;
    } withAnimation:nil key:@"reloadShow"];
}

// 目前特定的几个页面直接进行切换操作
- (void)enableShowNextRootView:(Class)viewClass {
    WMBaseViewController *rootCtrl = (WMBaseViewController *)(GMNavigationController *)AppDelegate.navigation.childViewControllers[0];
    
    if (rootCtrl && [rootCtrl isKindOfClass:viewClass]) {
        if (self.rootInfos.count == 0) {
            [self showHomeView];
        } else {
            [[AppDelegate shareInstance] showNextRootView];
        }
    } else {
        [[AppDelegate navigation] popToRootViewControllerAnimated:YES];
    }
}
@end
