//
//  AppDelegate+handleSchemeURL.h
//  Gengmei
//
//  Created by wangyang on 2016/11/8.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import "AppDelegate.h"

@interface AppDelegate (handleSchemeURL)
// 需要延迟到首页再处理的更美协议。该属性必须单独存在，不能与 handleDelayedSchemeURL 方法合并为其参数。
@property (nonatomic, copy) NSString *delayedSchemeURL;

/*
 调用此方法以处理从更美协议或者从unversalLink解析出的更美协议。另见 delayedSchemeURL 属性

 @note 该方法多次调用不会出现页面重复问题。因为依赖 delayedSchemeURL，该属性在使用后会被清空，所以不会出现多次重复
 @note 如果调用时不在首页，方法会什么也不做
 @note 需要在Home首页再调用一次，以保证 delayedSchemeURL 被正确处理
 */
- (void)handleDelayedSchemeURL;
@end
