//
//  AppDelegate.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/5.
//  Copyright © 2018年 Gengmei. All rights reserved.
//

#import "AppDelegate.h"
#import "GMTabBarController.h"
#import "AppDelegate+SDK.h"
#import "AppDelegate+AppInit.h"
#import "AppDelegate+handleSchemeURL.h"
#import "AppDelegate+RemotePush.h"
//#import "ALFaceFittingViewController.h"
#import "AppDelegate+ViewControl.h"
#import "GMLaunchImageController.h"
#import "AppDelegate+ALDownData.h"


@interface AppDelegate ()

@end

@implementation AppDelegate

- (UIWindow *)window {
    if (!_window) {
        _window = [[UIWindow alloc] initWithFrame:[UIScreen mainScreen].bounds];
        GMNavigationController *nav = [[GMNavigationController alloc] init];
        self.window.rootViewController = nav;
        AppDelegate.navigation.viewControllers = @[[GMLaunchImageController new]];
    }
    return _window;
}

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    // Override point for customization after application launch.
    
    [[UIApplication sharedApplication] setStatusBarOrientation:UIInterfaceOrientationPortrait animated:NO];    // APP 启动次数统计
    
    [self.window makeKeyAndVisible];
    
    [self synchronizeCookie:APIHOST];
    
    // 获取备用域名信息
    [self fetchBackupDominConfig];
    //极光推送
    [self setupJPushIfAllowed];
    // 通用参数依赖于定位，所以必须放在所有定位callback的第一个位置。
    [self registerNetserviceLocationCallbacks];
    // 网络配置初始化应该尽量放在最开始的位置
    [self setUpNetService];
    //监听网络状态
    [self setupNetWorkStatus];
    // 重要：app/config接口需要在网络配置成功后尽快启动。同时又依赖定位，见具体实现
    [self prepareFetchAppConfig];
    [self setupGlobalAppearence];
    [self fetchReportReason];
    [self setupSDKs];
    //下载个人中心页的数据
    [self downLoadDataMethod];
    /** 启动设置推送数量为0 */
    [[UIApplication sharedApplication] setApplicationIconBadgeNumber:0];
    /** 兼容iOS 11.0之后的ScrollView顶部会预留出一个状态栏的高度的问题 */
    if (@available(iOS 11.0, *)) {
        [[UIScrollView appearance] setContentInsetAdjustmentBehavior:UIScrollViewContentInsetAdjustmentNever];
    }
    
    return YES;
}


- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
}


- (void)applicationDidEnterBackground:(UIApplication *)application {
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}


- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
}


- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}


- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}

+ (instancetype)shareInstance
{
    return (AppDelegate *)[UIApplication sharedApplication].delegate;
}
#pragma mark - Getter
+ (GMNavigationController *)navigation {
    if ([AppDelegate.shareInstance.window.rootViewController isKindOfClass:[GMNavigationController class]]) {
        return (GMNavigationController *)AppDelegate.shareInstance.window.rootViewController;
    } else {
        return nil;
    }
}

+ (UIViewController *)visibleController {
    if ([AppDelegate.navigation.visibleViewController isKindOfClass:[UIAlertController class]]) {
        return AppDelegate.navigation.visibleViewController.presentingViewController;
    } else if ([AppDelegate.navigation.visibleViewController isKindOfClass:[GMTabBarController class]]) {
        return AppDelegate.tabBarController.current;
    } else {
        return AppDelegate.navigation.visibleViewController;
    }
}

+ (GMTabBarController *)tabBarController {
    if ([self.navigation.viewControllers.firstObject isKindOfClass:[GMTabBarController class]]) {
        return self.navigation.viewControllers.firstObject;
    } else {
        return nil;
    }
}

@end
