//
//  GMEmptyView+Alpha.m
//  GMAlpha
//
//  Created by Jing on 2018/12/6.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "GMEmptyView+Alpha.h"
#import <objc/runtime.h>

@implementation GMEmptyView (Alpha)

+ (void)initialize {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        [self p_hookOriginalSelector:@selector(setup) swizzledSelector:@selector(setupAlpha)];
        [self p_hookOriginalSelector:@selector(setType:) swizzledSelector:@selector(setAlphaType:)];
    });
}

+ (void)p_hookOriginalSelector:(SEL)originalSelector swizzledSelector:(SEL)swizzledSelector {
    Class class = [self class];

    Method originalMethod = class_getInstanceMethod(class,originalSelector);
    Method swizzledMethod = class_getInstanceMethod(class,swizzledSelector);
    
    BOOL didAddMethod = class_addMethod(class, originalSelector, method_getImplementation(swizzledMethod), method_getTypeEncoding(swizzledMethod));
    if (didAddMethod) {
        class_replaceMethod(class, swizzledSelector, method_getImplementation(originalMethod), method_getTypeEncoding(originalMethod));
    } else {
        method_exchangeImplementations(originalMethod, swizzledMethod);
    }
}

- (void)layoutSubviews {
    [super layoutSubviews];
}

- (void)setupAlpha {
    [self setupAlpha];
    self.tipLabel.textColor = UIColor.auxiliaryTextDark;
    self.tipButton = [GMButton buttonWithTitle:@"刷新" backgroundColor:RGBCOLOR_HEX(0x0093FF) titleFontSize:16 titleColor:UIColor.whiteColor];
    self.tipButton.layer.cornerRadius = 18;
    self.tipButton.layer.masksToBounds = YES;
    self.tipButton.hidden = YES;
    [self.tipButton addTarget:self action:@selector(reloadBtnTap) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:self.tipButton];
    
    [self.tipIcon mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_offset(160);
        make.width.mas_offset(186);
        make.height.mas_offset(114);
        make.centerX.mas_offset(0);
    }];
    [self.tipLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.tipIcon.mas_bottom).offset(15);
        make.centerX.mas_equalTo(self);
    }];
    [self.tipButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(150);
        make.height.mas_equalTo(36);
        make.centerX.mas_offset(0);
        make.top.equalTo(self.tipLabel.mas_bottom).offset(30);
    }];
}

- (void)setAlphaType:(GMEmptyViewType)type {
    [self setAlphaType:type];
    self.tipLabel.text = self.type == GMEmptyViewTypeException ? @"暂无网络，请刷新一下试试吧" : @"暂无相关内容";
}

- (void)setImageNeedReload:(BOOL)imageNeedReload {
    objc_setAssociatedObject(self, @selector(imageNeedReload), @(imageNeedReload), OBJC_ASSOCIATION_ASSIGN);
    if (imageNeedReload && !self.tipIcon.userInteractionEnabled) {
        UITapGestureRecognizer *tgr = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(reloadBtnTap)];
        self.tipIcon.userInteractionEnabled = YES;
        [self.tipIcon addGestureRecognizer:tgr];
    }
}

- (BOOL)imageNeedReload {
    return objc_getAssociatedObject(self, @selector(imageNeedReload));
}

@end
