//
//  GMTextField+Alpha.m
//  GMAlpha
//
//  Created by Jing on 2018/12/8.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "GMTextField+Alpha.h"
#import <objc/runtime.h>

@implementation GMTextField (Alpha)

- (void)setLeftView:(UIView *)leftView {
    [super setLeftView:leftView];
    [self setTextLeftEdge:8];
}

- (CGFloat)textLeftEdge {
    return [objc_getAssociatedObject(self, @selector(textLeftEdge)) floatValue];
}

- (CGFloat)textRightEdge {
    return  [objc_getAssociatedObject(self, @selector(textRightEdge)) floatValue];
}

- (void)setTextLeftEdge:(CGFloat)textLeftEdge {
    objc_setAssociatedObject(self, @selector(textLeftEdge), @(textLeftEdge), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (void)setTextRightEdge:(CGFloat)textRightEdge {
    objc_setAssociatedObject(self, @selector(textLeftEdge), @(textRightEdge), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
    
}

- (CGRect)textRectForBounds:(CGRect)bounds{
    CGRect rect = [super textRectForBounds:bounds];
    return UIEdgeInsetsInsetRect(rect, UIEdgeInsetsMake(3, self.textLeftEdge, 0, self.textRightEdge));
}

@end
