//
//  OCNavigationBar+ALBackImage.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/12/12.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "OCNavigationBar+ALBackImage.h"
#import <objc/runtime.h>

@implementation OCNavigationBar (ALBackImage)

+ (void)initialize {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        [self p_hookOriginalSelector:@selector(setup) swizzledSelector:@selector(setUpBackImage)];
    });
}

+ (void)p_hookOriginalSelector:(SEL)originalSelector swizzledSelector:(SEL)swizzledSelector {
    Class class = [self class];
    
    Method originalMethod = class_getInstanceMethod(class,originalSelector);
    Method swizzledMethod = class_getInstanceMethod(class,swizzledSelector);
    
    BOOL didAddMethod = class_addMethod(class, originalSelector, method_getImplementation(swizzledMethod), method_getTypeEncoding(swizzledMethod));
    if (didAddMethod) {
        class_replaceMethod(class, swizzledSelector, method_getImplementation(originalMethod), method_getTypeEncoding(originalMethod));
    } else {
        method_exchangeImplementations(originalMethod, swizzledMethod);
    }
}

- (void)layoutSubviews {
    [super layoutSubviews];
}

- (void)setUpBackImage {
    [self setUpBackImage];
    self.leftIcon = @"nav_back";
    
}
@end
