//
//  UIAlertController+GM.swift
//  GMKit
//
//  Created by wangyang on 16/7/7.
//  Copyright © 2016年 licong. All rights reserved.
//

import Foundation
// 因为
@objc extension UIAlertController {
    @objc static func showOKAlert(withTitle title: String?, message: String? = nil, actionTitle: String = "好", actionHandler: (() -> Void)? = nil) {
        let alert = UIAlertController(title: title, message: message, preferredStyle: .alert)
        let action = UIAlertAction(title: actionTitle, style: .default) { (_) in
            actionHandler?()
        }
        alert.addAction(action)
        UIApplication.shared.keyWindow?.rootViewController?.present(alert, animated: true, completion: nil)
    }

    @objc static func showCustomAlert(withTitle title: String?, message: String?) -> UIAlertController {
        let alert = UIAlertController(title: title, message: message, preferredStyle: .alert)
        AppDelegate.shareInstance().window.rootViewController?.present(alert, animated: true, completion: nil)
        return alert
    }
    
    @objc static func showCustomActionSheet(withTitle title: String?, message: String?) -> UIAlertController {
        let alert = UIAlertController(title: title, message: message, preferredStyle: .actionSheet)
        UIApplication.shared.keyWindow?.rootViewController?.present(alert, animated: true, completion: nil)
        return alert
    }

    @objc func addAction(_ title: String, actionHandler:(() -> Void)?) {
        let action = UIAlertAction(title: title, style: .default) { (_) in
            actionHandler?()
        }
        addAction(action)
    }
    
//    @objc static func alert(_ title: String, leftTitle: String?, rightTitle: String?, leftAlterAction: (() -> Void)?, rightAlertAction: (() -> Void)?) -> UIAlertController {
//        let alertController = UIAlertController(title: title, message: "", preferredStyle: UIAlertControllerStyle.alert)
//        var leftAction: UIAlertAction
//        var rightAction: UIAlertAction
//        if let leftTitle = leftTitle {
//            leftAction = UIAlertAction(title: leftTitle, style: UIAlertActionStyle.default) { (_) -> Void in
//                if let action = leftAlterAction { action() }
//            }
//            alertController.addAction(leftAction)
//        }
//        
//        if let rightTitle = rightTitle {
//            rightAction = UIAlertAction(title: rightTitle, style: UIAlertActionStyle.default) { (_) -> Void in
//                if let action = rightAlertAction { action() }
//            }
//            alertController.addAction(rightAction)
//        }
//        return alertController
//    }
}
