//
//  GMClientH5Object.m
//  Gengmei
//
//  Created by wangyang on 7/25/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "GMClientH5Object.h"

/**
 *  @author licong, 15-12-25 15:12:44
 *
 *  JSCore引擎调用OC做UI渲染操作，必须保证是在主线程执行，所以都加了 dispatch_async 以保证主线程工作
 *
 */
@implementation GMClientH5Object

- (void)jsObjShowShareView:(NSString *)JSONstring{
    if ([self.delegate respondsToSelector:@selector(jsObjShowShareViewWithJSONString:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsObjShowShareViewWithJSONString:JSONstring];
        });
    }
}

- (void)showWXShareView:(NSString *)JSONstring{
    if ([self.delegate respondsToSelector:@selector(jsShowWXShareViewWithJSONString:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowWXShareViewWithJSONString:JSONstring];
        });
    }
}

- (void)jsPop:(BOOL)animated{
    if ([self.delegate respondsToSelector:@selector(jsPopViewControllerAnimated:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsPopViewControllerAnimated:animated];
        });
    }
}

- (NSString *)domain{
    
    return APIHOST;
}

- (void)showLoading{
    if ([self.delegate respondsToSelector:@selector(jsShowLoading)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowLoading];
        });
    }
}

- (void)hideLoading{
    if ([self.delegate respondsToSelector:@selector(jsHideLoading)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsHideLoading];
        });
    }
}

- (void)showAlert:(NSString *)JSONString{
    if ([self.delegate respondsToSelector:@selector(jsShowAlertViewWithJSONString:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowAlertViewWithJSONString:JSONString];
        });
    }
}

- (void)showConfirm:(NSString *)JSONString{
    if ([self.delegate respondsToSelector:@selector(jsShowConfirmViewWithJSONString:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowConfirmViewWithJSONString:JSONString];
        });
    }
}

- (void)showToast:(NSString *)JSONString{
    if ([self.delegate respondsToSelector:@selector(jsShowToastWithJSONString:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowToastWithJSONString:JSONString];
        });
    }
}

- (void)trackEvent:(NSString *)JSONString {
    if ([self.delegate respondsToSelector:@selector(jsTrackEvent:)]) {
        [self.delegate jsTrackEvent:JSONString];
    }
}

- (void)playVideo:(NSString *)JSONString {
    if ([self.delegate respondsToSelector:@selector(jsPlayVideo:)]) {
        [self.delegate jsPlayVideo:JSONString];
    }
}

- (void)getAddressBook {
    if ([self.delegate respondsToSelector:@selector(jsGetAddressBook)]) {
        [self.delegate jsGetAddressBook];
    }
}

- (BOOL)isLocationEnable {
    if ([self.delegate respondsToSelector:@selector(jsIsLocationEnable)]) {
       return [self.delegate jsIsLocationEnable];
    } else {
        return NO;
    }
}

- (void)chooseOneContactPerson:(NSString *)key {
    if ([self.delegate respondsToSelector:@selector(jsChooseOneContactPerson:)]) {
        [self.delegate jsChooseOneContactPerson:key];
    }
}

- (void)logout {
    if ([self.delegate respondsToSelector:@selector(jsLogout)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsLogout];
        });
    }
}

- (void)share:(NSString *)shareDataString withType:(NSString *)type{
    if ([self.delegate respondsToSelector:@selector(jsShare:withType:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShare:shareDataString withType:type];

        });
    }
}

- (void)openBrowser:(NSString *)url{
    if ([self.delegate respondsToSelector:@selector(jsOpenBrowser:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsOpenBrowser:url];
        });
    }
}

- (void)jumpToLocationSettings {
    if ([self.delegate respondsToSelector:@selector(jsJumpToLocationSettings)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsJumpToLocationSettings];
        });
    }
}

- (void)locationShowAlertIfNotAllowed {
    if ([self.delegate respondsToSelector:@selector(jsLocationShowAlertIfNotAllowed)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsLocationShowAlertIfNotAllowed];
        });
    }
}

- (void)remindEvent:(NSString *)jsonString {
    if ([self.delegate respondsToSelector:@selector(jsRemindEvent:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsRemindEvent:jsonString];
        });
    }
}

- (void)insurancePurchase:(BOOL)hasBought {
    if ([self.delegate respondsToSelector:@selector(jsInsurancePurchase:)]) {
        NSDictionary *dict = @{@"has_bought": @(hasBought)};
        [self.delegate jsInsurancePurchase:dict];
    }
}

- (void)callPhone:(NSString *)phone {
    if ([self.delegate respondsToSelector:@selector(jsCallPhone:)]) {
        [self.delegate jsCallPhone:phone];
    }
}



- (void)sendMessage:(NSString *)phone withBody:(NSString *)body {
    if ([self.delegate respondsToSelector: @selector(jsSendMessage:withBody:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsSendMessage:phone withBody:body];
        });
    }
}

- (void)setHeaderHeight:(NSInteger)height {
    if ([self.delegate respondsToSelector: @selector(jsSetHeaderHeight:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsSetHeaderHeight:height];
        });
    }
}

- (void)setLocalStorage:(NSString *)key WithBody:(NSString *)value {
    if ([self.delegate respondsToSelector: @selector(jsSetLocalStorage:withStorage:)]) {
        [self.delegate jsSetLocalStorage:key withStorage:value];
    }
}

- (NSString *)getLocalStorage:(NSString *)key {
    if ([self.delegate respondsToSelector: @selector(jsGetLocalStorage:)]) {
        return [self.delegate jsGetLocalStorage:key];
    } else {
        return @"";
    }
}

- (void)syncSSOInfo:(NSString *)info {
    if ([self.delegate respondsToSelector:@selector(jsSyncSSOInfo:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsSyncSSOInfo:info];
        });
    }
}
//场景化弹窗
- (void)showTaskAlert:(NSString *)extra {
    if ([self.delegate respondsToSelector:@selector(jsShowTaskAlert:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowTaskAlert:extra];
        });
    }
}

- (void)newbieCouponGot:(NSInteger)flag {
    if ([self.delegate respondsToSelector:@selector(jsNewbieCouponGot:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsNewbieCouponGot:flag];
        });
    }
}

- (void)clipboard:(NSString *)boardText {
    if ([self.delegate respondsToSelector:@selector(jsClipboard:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsClipboard:boardText];
        });
    }
}

- (void)showActionSheet:(NSString *)jsonString {
    if ([self.delegate respondsToSelector:@selector(jsShowActionSheet:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowActionSheet:jsonString];
        });
    }
}

- (void)rightbuttonCallBack:(NSString *)json {
    if ([self.delegate respondsToSelector:@selector(jsRightbuttonCallBack:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsRightbuttonCallBack:json];
        });
    }
}

- (void)globalDataLoaded:(NSString *)jsonString {
    if ([self.delegate respondsToSelector:@selector(jsGlobalDataLoaded:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsGlobalDataLoaded:jsonString];
        });
    }
}

- (int)isUserLogin {
    if ([self.delegate respondsToSelector: @selector(jsIsUserLogin)]) {
        return [self.delegate jsIsUserLogin];
    } else {
        return 0;
    }
}

- (void)jsControlTitleBarVisible:(BOOL)isShow {
    if ([self.delegate respondsToSelector:@selector(jsControlTitleBarVisible:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsControlTitleBarVisible:isShow];
        });
    }
}

-(void)dealloc{
    
}

@end

