//
//  UIViewController+UrlScheme.h
//  Gengmei
//
//  Created by Thierry on 4/21/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN
@interface UIViewController (UrlScheme)

/**
 *  @brief 获取所有协议Host列表
 *
 *  @return dict
 *
 *  @since 5.9.3
 */
- (NSDictionary *)getHostDictionary;

/**
 使用例子：[self pushHost:HOST_HOMEPAGE query:@"uid=%ld", (long)uid];

 @param host 更美协议的host
 @param format query部分
 */
- (void)pushHost:(NSString *)host query:(nullable NSString *)format, ... NS_FORMAT_FUNCTION(2,3);

/**
 push完整的更美协议

 @param urlScheme 完整的更美协议
 */
- (void)pushScheme:(NSString *)urlScheme;

@end
NS_ASSUME_NONNULL_END
