//
//  WMDiaryAndTopicBaseController.h
//  ZhengXing
//
//  Created by wangyang on 3/5/15.
//  Copyright (c) 2015 Wanmei Creative. All rights reserved.
//

#import "Alpha-Swift.h"

@interface WMBaseWebViewController : WMBaseViewController

@property (nonatomic, strong) GMWebViewComponent *webCompent;

/**
 *  @brief  要请求的 H5 url 除了 http://backend.dev.gengmei.cc/hybrid" 这部分后的path。比如一个h5是 http://backend.dev.gengmei.cc/hybrid/topic/3332214，那么path指需要赋值@"/topic/3332214"即可.
 @note 在viewDidLoad前配置好。必须以"/"开头。重写moreQueryParameters可以添加额外query
 */
@property (nonatomic, strong) NSString *path;

/**
 *  @brief  对于从服务器那儿获取到的完整H5 url，使用该属性。
 @note 在viewDidLoad前配置好。会覆盖path属性。重写moreQueryParameters可以添加额外query
 */
@property (nonatomic, strong) NSString *fullURL;

/**
 *  @brief  重写该方法，为fullURL在请求前添加更多参数。必须以 & 开头
 *  原方法只返回了空字符串，不需要call super
 *
 *  @return 要额外添加的参数。如：&key1=value&key2=value
 */
- (NSString *)moreQueryParameters;

/**
 重写该方法以修改待加载的URLRequest并且执行 [_webView loadRequest:request];
 */
- (void)webViewLoadRequest;

/**
 调用该方法以重新构造URL并且[_webView loadRequest:request];
 */
- (void)reloadURL;

/**
处理请求URL
*/
- (void)handleURL;

/*
 * 重新加载URL
 */
- (void)refreshWebView;

// 处理H5 埋点数据
- (void)trackEventGlobalPage:(NSDictionary *)data;
@end
