//
//  GMPopupBgView.h
//  Gengmei
//
//  Created by wangyang on 2018/3/2.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

@protocol GMPopupBgViewDelegate <NSObject>
@optional
- (void)popupBgViewDidDismiss;
- (void)didCompletedAnimation;
@end

typedef NS_ENUM(NSUInteger, GMPopupAnimationType) {
    GMPopupAnimationTypeNone = 0,
    GMPopupAnimationTypeFade,
    // 从底部滑出
    GMPopupAnimationTypeFlipFromBottom,
    // 从中心立即显示并做弹簧动画
    GMPopupAnimationTypeSpringScaleFromCenter,
    // 自定义
    GMPopupAnimationTypeCustom = 100,
};

/**
 所有使用半透明背景的popView，都使用该Class作为父类
 */
@interface GMPopupBgView : GMView<UIGestureRecognizerDelegate>

// 半透明背景颜色。默认是[UIColor colorWithWhite:0 alpha:0.6]
@property (nonatomic, strong) UIColor *bgAlphaColor;
@property (nonatomic, weak) id<GMPopupBgViewDelegate> delegate;

/**
 container的背景颜色，位置（坐标或者约束）是可以自定义的。
 container的大小可以使用约束自动计算，也可以显示的设置size
 */
@property (nonatomic, strong) UIView *container;

/**
 点击空白区域不隐藏视图
 */
@property (nonatomic, assign) BOOL disableCancelTouch;

/**
 使用 GMPopupAnimationTypeCustom 时，可以自定义container的动画。默认为 GMPopupAnimationTypeFlipFromBottom
 自定义动画必须在 containerShowAnimation 与 containerHideAnimation 中实现
 */
@property (nonatomic, assign) GMPopupAnimationType animationType;
// 默认是0.3秒
@property (nonatomic, assign) CGFloat animationDuration;
@property (nonatomic, copy) void (^containerShowAnimation) (GMPopupBgView *bgView, CGFloat duration);
@property (nonatomic, copy) void (^containerHideAnimation) (GMPopupBgView *bgView, CGFloat duration);

/**
 点击半透明背景会触发该方法隐藏，执行隐藏动画，然后removeFromSuperview。
 注意：不会调用delegate.popupBgViewDidDismiss()
 */
- (void)hide;

@end
