//
//  GMPopupBgView.m
//  Gengmei
//
//  Created by wangyang on 2018/3/2.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMPopupBgView.h"
@interface GMPopupBgView () <UIGestureRecognizerDelegate>
@end
@implementation GMPopupBgView

- (void)setup {
    [super setup];
    self.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT);
    self.animationDuration = 0.3;
    self.animationType = GMPopupAnimationTypeFlipFromBottom;
    self.bgAlphaColor = [UIColor colorWithWhite:0 alpha:0.6];
    self.backgroundColor = [UIColor colorWithWhite:0 alpha:0];
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(didTapView)];
    tap.delegate = self;
    [self addGestureRecognizer:tap];
    tap.delegate = self;
    self.userInteractionEnabled = YES;

    _container = [[UIView alloc] initWithFrame:CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, 322)];
    _container.backgroundColor = [UIColor whiteColor];
    
    [self addSubview:_container];
}

- (void)didTapView {
    [self hide];
    if ([self.delegate respondsToSelector:@selector(popupBgViewDidDismiss)]) {
        [self.delegate popupBgViewDidDismiss];
    }
}

- (void)willMoveToSuperview:(UIView *)newSuperview {
    if (newSuperview == nil) {
        return;
    }

    switch (self.animationType) {
        case GMPopupAnimationTypeNone: {
            self.backgroundColor = self.bgAlphaColor;
            break;
        }
        case GMPopupAnimationTypeFade: {
            self.backgroundColor = self.bgAlphaColor;
            self.container.alpha = 0;
            [self animation:^{
                self.container.alpha = 1;
            }];
            break;
        }
        case GMPopupAnimationTypeFlipFromBottom: {
            [self animation:^{
                self.container.bottom = MAINSCREEN_HEIGHT;
                self.backgroundColor = self.bgAlphaColor;
            }];
            break;
        }
        case GMPopupAnimationTypeSpringScaleFromCenter: {
            [self animation:^{
                self.backgroundColor = self.bgAlphaColor;
            }];
            self.container.transform = CGAffineTransformMakeScale(0.7, 0.7);
            [UIView animateWithDuration:self.animationDuration delay:0 usingSpringWithDamping:0.3 initialSpringVelocity:0 options:0 animations:^{
                // 放大
                self.container.transform = CGAffineTransformMakeScale(1, 1);
            } completion:nil];

            break;
        }
        case GMPopupAnimationTypeCustom: {
            [self animation:^{
                self.backgroundColor = self.bgAlphaColor;
            }];
            self.containerShowAnimation(self, self.animationDuration);
            break;
        }
        default:
            break;
    }
}

- (void)hide {
    [UIView animateWithDuration:self.animationDuration animations:^{
        self.backgroundColor = [UIColor colorWithWhite:0 alpha:0];
    } completion:^(BOOL finished) {
        [self removeFromSuperview];
    }];

    switch (self.animationType) {
        case GMPopupAnimationTypeNone:
        case GMPopupAnimationTypeFade: {
            [self animation:^{
                self.container.alpha = 0;
            }];
            break;
        }
        case GMPopupAnimationTypeFlipFromBottom: {
            [self animation:^{
                self.container.top = MAINSCREEN_HEIGHT;
            }];
            break;
        }
        case GMPopupAnimationTypeSpringScaleFromCenter: {
            [self animation:^{
                self.container.alpha = 0;
            }];
            break;
        }
        case GMPopupAnimationTypeCustom: {
            self.containerHideAnimation(self, self.animationDuration);
            break;
        }
        default:
            break;
    }
}

- (void)animation:(void (^)(void))block {
    [UIView animateWithDuration:self.animationDuration animations:^{
        block();
    } completion:^(BOOL finished) {
        if ([self.delegate respondsToSelector:@selector(didCompletedAnimation)]) {
            [self.delegate didCompletedAnimation];
        }
    }];
}

- (BOOL)gestureRecognizer:(UIGestureRecognizer*)gestureRecognizer shouldReceiveTouch:(UITouch*)touch {
    // 如果点击了container区域, 不需要响应手势
    if (CGRectContainsPoint(self.container.frame, [touch locationInView:self])) {
        return NO;
    } else if (self.disableCancelTouch) {
        return NO;
    } else {
        return YES;
    }
}
@end
