//
//  GMTitleCell.m
//  Gengmei
//
//  Created by wangyang on 2018/3/31.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMTitleCell.h"

@implementation GMTitleCell {
    UIImageView *_selection;
}

- (void)setup{
    [super setup];
    self.titleLabel = [GMLabel labelWithTextColor:UIColor.bodyText fontSize:14];
    self.titleLabel.highlightedTextColor = [UIColor colorWithHex:0x4abab4];
    [self.contentView addSubview:self.titleLabel];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.centerY.mas_equalTo(0);
    }];

    _selection = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"expandFilterSelection"]];
    [self addSubview:_selection];
    [_selection mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(0);
        make.right.mas_equalTo(-20);
        make.size.sizeOffset(CGSizeMake(15, 10));
    }];

    [self updateBottomLineConstraintsWithLeft:20 right:20]; 
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    self.titleLabel.highlighted = selected;
    _selection.hidden = !selected;
}

@end
