//
//  WMShareCellCollectionViewCell.m
//  Gengmei
//
//  Created by Sean Lee on 1/23/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "GMShareCell.h"
#import "GMShareFlowLayout.h"

@implementation GMShareCell

- (instancetype)initWithFrame:(CGRect)frame{
    
    self  = [super initWithFrame:frame];
    if (self) {
        
        _shareButton = [GMButton new];
        _shareButton.titleLabel.font = [UIFont gmFont:12];
        [_shareButton setTitleColor:UIColor.auxiliaryTextLight forState:UIControlStateNormal];
        [_shareButton setTitle:@"好友QQ" forState:UIControlStateNormal];
        [_shareButton setImage:[UIImage imageNamed:@"share_weixin_session"] forState:UIControlStateNormal];
        [_shareButton addTarget:self action:@selector(shareButtonClicked:) forControlEvents:UIControlEventTouchUpInside];
        [_shareButton sizeToFit];
        [self.contentView addSubview:_shareButton];
        //图片是40x40
        _shareButton.frame = CGRectMake(0, 0, SHARE_BUTTON_WIDTH, SHARE_BUTTON_HEIGHT);
        _shareButton.userInteractionEnabled = YES;
        //设置图片居上，文字居下
        CGFloat spacing = 15;
        CGSize imageSize = _shareButton.currentImage.size;
        CGSize titleSize = [_shareButton.currentTitle sizeWithFont:[UIFont gmFont:12] boundSize:CGSizeMake(_shareButton.frame.size.width, CGFLOAT_MAX)];
        
        CGFloat totalHeight = (imageSize.height + titleSize.height + spacing);
        _shareButton.imageEdgeInsets = UIEdgeInsetsMake(- (titleSize.height), (SHARE_BUTTON_WIDTH - imageSize.width)/2, 0.0, 0.0);
        _shareButton.titleEdgeInsets = UIEdgeInsetsMake(0.0, - (imageSize.width), - (totalHeight - titleSize.height),0.0);
    }
    return  self;
}

- (void)shareButtonClicked:(UIButton *)button{
    if (self.transferResponseChainBlock) {
        self.transferResponseChainBlock();
    }
}


@end
