//
//  WMShareView.h
//  Gengmei
//
//  Created by Sean Lee on 1/22/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GMShareCell.h"
#import "GMShareSDK.h"

@class GMShareView;
@class GMCollectionView;
@protocol GMShareViewDelegate <NSObject>

@required
/**
 *  @brief  在shareView add到super view前，会调用该deleage，在这个delegate里配置shareView，比如hasFav、showDelete等属性配置
 *
 */
- (void)willShowShareView:(GMShareView *)shareView;

@optional
/**   @brief  定制分享定制内容*/
- (NSMutableDictionary *)fetchSharePublishContent:(GMSharePlatform)shareType;
/**   @brief  删除*/
- (void)deleteContent;
/**   @brief  收藏*/
- (void)shareView:(GMShareView *)shareView favriteContentWithIndexPath:(NSIndexPath *)indexPath;
/**   @brief  刷新H5*/
- (void)refreshWebView;
/**   @brief  举报*/
- (void)showReport;
/***  @brief  复制链接*/
- (void)copyShareUrl;
/***  @brief  取消关注圈子*/
- (void)unFollowZone;
/***  @brief  邀请回复(问题详情和回复详情界面)*/
- (void)inviteAnswer;
// 如果需要动态变化businessId，就实现这个方法
- (NSString *)shareViewNeedBusinessId;
/** 分享成功 */ 
- (void)shareResponseSuccess;
@end


/**
 *  @brief  弹出通用分享、收藏、等工具视图。可以包含的功能还有圈子的关注、取消关注、举报，刷新等。具体见属性注释。
 @note
    使用 shareView 初始化，但返回的并不是一个单例
 */
@interface GMShareView : GMView

@property (nonatomic, weak) id<GMShareViewDelegate> delegate;
/**   @brief  collectionView*/
@property (nonatomic,strong) GMCollectionView * shareCollectionView;

/**   @brief  整个中间的背景View */
@property (nonatomic, strong) GMView *bgView;

/**   @brief  是否收藏过 */
@property (assign, nonatomic) BOOL hasFav;

/**   @brief  是否显示微信快照和朋友圈快照。默认NO*/
@property (assign, nonatomic) BOOL showScreenshot;
/**   @brief  是否显示收藏项目。默认NO*/
@property (assign, nonatomic) BOOL showFavor;
/**   @brief  是否显示删除帖子。 默认NO*/
@property (assign, nonatomic) BOOL showDelete;
/**   @brief  是否显示举报帖子。 默认NO*/
@property (assign, nonatomic) BOOL showReport;

/**   @brief  是否显示取消关注（用于圈子的取消关注）默认NO*/
@property (assign, nonatomic) BOOL showCancelFollow;

/**   @brief  是否显示拷贝H5链接 默认YES*/
@property (nonatomic, assign) BOOL showCopyLink;

/**   @brief  是否显示用于H5的刷新 默认YES*/
@property (nonatomic, assign) BOOL showRefresh;

/**   @brief  是否显示邀请回复 默认NO*/
@property (nonatomic, assign) BOOL showInviteAnswer;

/**   @brief  分享文案标题*/
@property (nonatomic, strong) NSString *shareTitle;

/** 分享url, 用于直接点击分享(没弹窗形式) */
@property (nonatomic, copy) NSString *shareUrl;

/**   @brief  显示分享界面*/
- (void)showWithShareUrl:(NSString *)shareUrl;
/**   @brief  隐藏分享界面。最后会remove super view*/
- (void)hideShareView;

/**
 *  @author wangyang, 16-01-22 19:01:00
 *
 *  @brief 调用该方法直接分享到指定平台，但仍会走 fetchSharePublishContent 这个代理方法以取得待分享的内容
 *  @param type 将要分享到的平台
 *  @since 5.9.0
 */
- (void)shareWithType:(GMSharePlatform)type;

@end
