//
//  GMCommonAlertView.swift
//  Gengmei
//
//  Created by Terminator on 2017/7/5.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

import UIKit

@objc protocol GMCommonAlertViewDelegate: class {
    func didClickCommonAlert(buttonIndex: Int, alertView: GMCommonAlertView)
}

@objcMembers
class GMCommonAlertView: GMView {

    let alertView = GMView()
    let titleLabel = GMLabel(textColor: UIColor.headlineText, fontSize: 16)
    let subLabel = GMLabel(textColor: UIColor.auxiliaryTextLight, fontSize: 14)
    var button1 = GMGradualButton()
    var button2: GMButton!
    var button3: GMButton!
    
    weak var delegate: GMCommonAlertViewDelegate?
    override func setup() {
        super.setup()
        setupSubviews()
    }
    
    private func setupSubviews() {
        backgroundColor = UIColor.black.withAlphaComponent(0.6)
        addSubview(alertView)
        alertView.backgroundColor = UIColor.white
        alertView.layer.cornerRadius = 10
        alertView.layer.masksToBounds = true
//        alertView.snp.makeConstraints { (make) in
//            make.centerY.equalToSuperview()
//            make.centerX.equalToSuperview()
//            make.size.equalTo(CGSize(width: 270, height: 280))
//        }
        
        let headerImage = GMImageView(image: UIImage(named: "notify_bell"))
        addSubview(headerImage)
//        headerImage.snp.makeConstraints { (make) in
//            make.centerX.equalToSuperview()
//            make.top.equalTo(alertView.snp.top).offset(-38)
//        }
        
        titleLabel.text = "打开推送通知"
        alertView.addSubview(titleLabel)
//        titleLabel.snp.makeConstraints { (make) in
//            make.centerX.equalToSuperview()
//            make.top.equalTo(70)
//        }
        
        subLabel.text = "第一时间接受TA的日记更新？"
        alertView.addSubview(subLabel)
//        subLabel.snp.makeConstraints { (make) in
//            make.centerX.equalToSuperview()
//            make.top.equalTo(titleLabel.snp.bottom).offset(5)
//        }
        
//        button1.setTitleColor(UIColor.white, for: UIControlState.normal)
//        button1.setTitle("确定打开", for: UIControlState.normal)
        button1.gradualColor = [UIColor(hex: 0x51D3E7), UIColor(hex: 0x3BE7DA)]
        button1.layer.cornerRadius = 20
        button1.layer.masksToBounds = true
        button1.titleLabel?.font = UIFont.gmFont(16)
        button1.tag = 1001
//        button1.addTarget(self, action: #selector(GMCommonAlertView.buttonTapAction(_:)), for: UIControlEvents.touchUpInside)
//        alertView.addSubview(button1)
//        button1.snp.makeConstraints { (make) in
//            make.centerX.equalToSuperview()
//            make.top.equalTo(subLabel.snp.bottom).offset(15)
//            make.size.equalTo(CGSize(width: 200, height: 40))
//        }
//        button1.setGradualChangeColor(colors: [UIColor(hex: 0x23E3E1), UIColor(hex: 0x2CD7E6)])

        button2 = addButtonWith("不用打开", backgroundColor: UIColor.clear, titleColor: UIColor.mainVisual, borderColor: UIColor.mainVisual)
//        button2.addTarget(self, action: #selector(GMCommonAlertView.buttonTapAction(_:)), for: UIControlEvents.touchUpInside)
        button2.tag = 1002
        button2.titleLabel?.font = UIFont.gmFont(16)
        alertView.addSubview(button2)
//        button2.snp.makeConstraints { (make) in
//            make.centerX.equalToSuperview()
//            make.top.equalTo(button1.snp.bottom).offset(15)
//            make.size.equalTo(CGSize(width: 200, height: 40))
//        }
        
        button3 = addButtonWith("不再提醒", backgroundColor: UIColor.clear, titleColor: UIColor.auxiliaryTextLight, borderColor: UIColor.clear)
//        button3.addTarget(self, action: #selector(GMCommonAlertView.buttonTapAction(_:)), for: UIControlEvents.touchUpInside)
        button3.tag = 1003
        alertView.addSubview(button3)
        button3.titleLabel?.font = UIFont.gmFont(14)
//        button3.snp.makeConstraints { (make) in
//            make.centerX.equalToSuperview()
//            make.top.equalTo(button2.snp.bottom).offset(10)
//            make.size.equalTo(CGSize(width: 200, height: 30))
//        }
    }
    
    // MARK: - 添加button
   private func addButtonWith(_ title: String, backgroundColor: UIColor, titleColor: UIColor, borderColor: UIColor) -> GMButton {
        let button = GMButton(title: title, backgroundColor: backgroundColor, titleFontSize: 14, titleColor: titleColor)
        button.layer.cornerRadius = 20
        button.layer.borderWidth = 0.5
        button.layer.borderColor = borderColor.cgColor
        button.layer.masksToBounds = true
        return button
    }
    
    func buttonTapAction(_ sender: GMButton) {
        let index = sender.tag - 1000
        delegate?.didClickCommonAlert(buttonIndex: index, alertView: self)
    }
    
    @objc func show() {
        UIApplication.shared.keyWindow?.addSubview(self)
//        self.snp.makeConstraints { (make) in
//            make.edges.equalTo(UIEdgeInsets.zero)
//        }
    }
    
    @objc func dismiss() {
        self.perform(#selector(removeFromSuperview))
    }

}
