//
//  GMSegmentViewWithRedBadge.m
//  Gengmei
//
//  Created by 汪俊 on 2016/11/15.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMSegmentViewWithRedBadge.h"

@implementation GMSegmentViewWithRedBadge {
    NSArray<UIImageView *> *_badgeViews;
}

- (void)setup {
    [super setup];
    self.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, 44);
    self.backgroundColor = [UIColor whiteColor];
    self.titleTextAttributes = @{NSFontAttributeName:[UIFont gmFont:15],
                                    NSForegroundColorAttributeName:UIColor.auxiliaryTextLight};
    self.selectedTitleTextAttributes = @{NSFontAttributeName:[UIFont gmBoldFont:15],
                                            NSForegroundColorAttributeName:UIColor.bodyText};
    self.showIndicator = YES;
    self.widthStyle = WYSegmentViewWidthStyleFixed;
    self.indicatorColor = UIColor.auxiliaryTextGreen;
}

- (void)layoutSegments {
    [super layoutSegments];
    NSMutableArray *badges = [NSMutableArray array];
    //添加小红点
    for (UIView *subview in self.scrollView.subviews) {
        for (UIView *view in subview.subviews) {
            if ([view isKindOfClass:[UIButton class]]) {
                UIImageView *redBadge = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"red_badge"]];
                redBadge.hidden = YES;
                UIButton *button = (UIButton *)view;
                [button.titleLabel addSubview:redBadge];
                [redBadge mas_makeConstraints:^(MASConstraintMaker *make) {
                    make.top.mas_equalTo(-1);
                    make.left.mas_equalTo(button.titleLabel.width);
                }];
                [badges addObject:redBadge];
            }
        }
    }
    _badgeViews = badges;
}

- (void)showBadge: (BOOL)isShow atIndex: (NSInteger)index {
    UIImageView *badgeView = _badgeViews[index];
    badgeView.hidden = !isShow;
}

- (BOOL)isShowBadgeAtIndex:(NSInteger)index {
    return !_badgeViews[index].hidden;
}

@end
