//
//  WYSegmentView+Factory.m
//  Gengmei
//
//  Created by wangyang on 16/2/17.
//  Copyright © 2016年 Wanmeichuangyi. All rights reserved.
//

#import "WYSegmentView+Factory.h"

@implementation WYSegmentView (Factory)

+ (WYSegmentView *)baseThemeSegment {
    WYSegmentView *segment = [[WYSegmentView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 44)];
    segment.backgroundColor = [UIColor whiteColor];
    segment.showIndicator = YES;
    return segment;
}

+ (WYSegmentView *)dynamicSegment {
    WYSegmentView *segment = [self baseThemeSegment];
    segment.titleTextAttributes = @{NSFontAttributeName:[UIFont gmFont:15],
                                    NSForegroundColorAttributeName:UIColor.auxiliaryTextLight};
    segment.selectedTitleTextAttributes = @{NSFontAttributeName:[UIFont gmBoldFont:15],
                                            NSForegroundColorAttributeName:UIColor.bodyText};
    segment.scrollView.contentInset = UIEdgeInsetsMake(0, 13, 0, 13);
    segment.widthStyle = WYSegmentViewWidthStyleDynamic;
    segment.itemHorizonalPadding = 14;
    return segment;
}

+ (WYSegmentView *)fullWidthSegment {
    WYSegmentView *segment = [self baseThemeSegment];
    segment.titleTextAttributes = @{NSFontAttributeName:[UIFont gmFont:15],
                                    NSForegroundColorAttributeName:UIColor.auxiliaryTextLight};
    segment.selectedTitleTextAttributes = @{NSFontAttributeName:[UIFont gmBoldFont:15],
                                            NSForegroundColorAttributeName:UIColor.bodyText};
    segment.widthStyle = WYSegmentViewWidthStyleFixed;
    return segment;
}

+ (WYSegmentView *)myOrderListSegment {
    WYSegmentView *segment = [self baseThemeSegment];
    segment.titleTextAttributes = @{NSFontAttributeName:[UIFont gmFont:14],
                                    NSForegroundColorAttributeName:UIColor.auxiliaryTextLight};
    segment.selectedTitleTextAttributes = @{NSFontAttributeName:[UIFont gmBoldFont:14],
                                            NSForegroundColorAttributeName:UIColor.bodyText};
    segment.widthStyle = WYSegmentViewWidthStyleFixed;
    return segment;
}
@end
