//
//  ALHelpManager.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#define kIsIOS7  ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0)

#import "ALHelpManager.h"

@implementation ALHelpManager

+ (CGFloat)getWidthOfString:(NSString *)string font:(UIFont *)font height:(float)height
{
    CGSize size = CGSizeZero;
    
    if (kIsIOS7) {
        
        NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc]init];
        paragraphStyle.lineBreakMode = NSLineBreakByWordWrapping;
        NSDictionary *attributes = @{NSFontAttributeName:font, NSParagraphStyleAttributeName:paragraphStyle.copy};
        
        size = [string boundingRectWithSize:CGSizeMake(MAXFLOAT, height) options:
                NSStringDrawingUsesFontLeading |
                NSStringDrawingUsesLineFragmentOrigin
                                 attributes:attributes context:nil].size;
    }
    else
    {
        
    }
    return size.width;
}

@end
