//
//  ALUpLoadManager.h
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/26.
//  Copyright © 2018 Gengmei. All rights reserved.
//

typedef NS_ENUM(NSInteger , GetTokenType) {
    
    GetTokenTypeImage = 1 ,/** 图片 */
    GetTokenTypeVideo = 2 ,/** 视频文件 */
    GetTokenTypeSaoFace = 3/** face扫脸相关文件 */
};

#import <Foundation/Foundation.h>

typedef void(^returnImageUrlBlock)(NSString *path);

typedef void(^returnFailBlock)(NSString *message);

@interface ALUpLoadManager : NSObject

+ (instancetype)shareInstance;
@property (nonatomic, assign) NSString *fileSuffer;
/**
 * 七牛上传图片
 */
- (void)setImage:(UIImage *)image getTokenType:(GetTokenType)type fileSuffix:(NSString *)fileSuffix block:(returnImageUrlBlock)block failBlock:(returnFailBlock)failBlock;
/**
 * 七牛上传文件
 */
- (void)setFile:(NSString *)file getTokenType:(GetTokenType)type block:(returnImageUrlBlock)block failBlock:(returnFailBlock)failBlock;
/**
 * 七牛上传视频
 */
- (void)setData:(NSData *)data getTokenType:(GetTokenType)type key:(NSString *)key block:(returnImageUrlBlock)block failBlock:(returnFailBlock)failBlock;

/**
 * getToken
 */
- (void)getToken:(GetTokenType)type block:(returnImageUrlBlock)block failBlock:(returnFailBlock)failBlock;

@end
