//
//  WMLauchManager.h
//  Gengmei
//
//  Created by Sean Lee on 1/15/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "WMAppConfigObject.h"

@interface GMLaunchManager : NSObject

/***  和user类似，不允许对其赋值,防止有些属性监听后赋值引起crash */
@property (nonatomic, strong) WMAppConfigObject *appConfigObject;

+ (instancetype )shareManager;


#pragma mark ----分版本统计启动次数----
/**
 *  @brief  对应用程序的启动次数统计
 *
 */
+ (void)startStatisticalAppLaunchCount;

/**
 *  @brief  统计所有应用程序的所有版本的启动次数和
 *
 *  @return 应用程序的启动次数和
 */
- (NSInteger )lauchCountForAllVersion;


/**
 *  @brief  获取应用程序某个版本当前的的启动次数
 *
 *  @param version 应用程序版本号
 *
 *  @return 应用程序某个版本的启动次数
 */
- (NSInteger )lauchCountForVersion:(NSString *)version;

/**
 *  @author licong, 16-01-04 11:01:48
 *
 *  更新直接跳转到App Store
 *
 *  @since 5.8
 */
+ (void)jumpToAppStore;


#pragma mark - 大广告

/**
 *  @author licong, 16-01-04 11:01:28
 *
 *  保存启动配置信息
 *
 *  @since 5.8
 */
- (void)saveGreeting;

/**
 *  @author wangyang, 16-04-14 15:04:32
 *
 *  是否需要展示大广告。关键要看greeting.image对应的图片是否存在，而不是greeting object是否存在
 *  @return YES表示需要大广告
 *  @since 5.9.3
 */
+ (BOOL)greetingImageExist;
+ (void)downloadGreetingImage;

// 获取存储的大广告数据
+ (WMLaunchScreenObject *)greeting;
@end
